/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.plugin.strategy.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class WebClientStrategyInterceptor
extends AbstractStrategyInterceptor
implements ExchangeFilterFunction {
    private static final Logger LOG = LoggerFactory.getLogger(WebClientStrategyInterceptor.class);
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Value(value="${spring.application.strategy.web.client.core.header.transmission.enabled:true}")
    protected Boolean webClientCoreHeaderTransmissionEnabled;

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        ClientRequest.Builder requestBuilder = ClientRequest.from((ClientRequest)request);
        this.interceptInputHeader();
        this.applyInnerHeader(requestBuilder);
        this.applyOuterHeader(requestBuilder);
        ClientRequest newRequest = requestBuilder.build();
        this.interceptOutputHeader(newRequest);
        return next.exchange(newRequest);
    }

    private void applyInnerHeader(ClientRequest.Builder requestBuilder) {
        String zone;
        String environment;
        String region;
        requestBuilder.header("n-d-service-group", new String[]{this.pluginAdapter.getGroup()});
        requestBuilder.header("n-d-service-type", new String[]{this.pluginAdapter.getServiceType()});
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            requestBuilder.header("n-d-service-app-id", new String[]{serviceAppId});
        }
        requestBuilder.header("n-d-service-id", new String[]{this.pluginAdapter.getServiceId()});
        requestBuilder.header("n-d-service-address", new String[]{this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()});
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            requestBuilder.header("n-d-service-version", new String[]{version});
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            requestBuilder.header("n-d-service-region", new String[]{region});
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            requestBuilder.header("n-d-service-env", new String[]{environment});
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            requestBuilder.header("n-d-service-zone", new String[]{zone});
        }
    }

    private void applyOuterHeader(ClientRequest.Builder requestBuilder) {
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                if (this.webClientCoreHeaderTransmissionEnabled.booleanValue()) {
                    requestBuilder.header(headerName, new String[]{headerValue});
                    continue;
                }
                boolean isCoreHeaderContains = StrategyUtil.isCoreHeaderContains(headerName);
                if (isCoreHeaderContains) continue;
                requestBuilder.header(headerName, new String[]{headerValue});
            }
        }
        if (this.webClientCoreHeaderTransmissionEnabled.booleanValue()) {
            String routeAddressBlacklist;
            String routeIdBlacklist;
            String routeAddressFailover;
            String routeZoneFailover;
            String routeEnvironmentFailover;
            String routeRegionFailover;
            String routeRegionTransfer;
            String routeVersionFailover;
            String routeVersionPrefer;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String routeRegion;
            String routeVersion;
            ClientRequest request = requestBuilder.build();
            HttpHeaders headers = request.headers();
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version")) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getRouteVersion()))) {
                requestBuilder.header("n-d-version", new String[]{routeVersion});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region")) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getRouteRegion()))) {
                requestBuilder.header("n-d-region", new String[]{routeRegion});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-env")) && StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getRouteEnvironment()))) {
                requestBuilder.header("n-d-env", new String[]{routeEnvironment});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address")) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getRouteAddress()))) {
                requestBuilder.header("n-d-address", new String[]{routeAddress});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-weight")) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getRouteVersionWeight()))) {
                requestBuilder.header("n-d-version-weight", new String[]{routeVersionWeight});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-weight")) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getRouteRegionWeight()))) {
                requestBuilder.header("n-d-region-weight", new String[]{routeRegionWeight});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-prefer")) && StringUtils.isNotEmpty((CharSequence)(routeVersionPrefer = this.strategyContextHolder.getRouteVersionPrefer()))) {
                requestBuilder.header("n-d-version-prefer", new String[]{routeVersionPrefer});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-failover")) && StringUtils.isNotEmpty((CharSequence)(routeVersionFailover = this.strategyContextHolder.getRouteVersionFailover()))) {
                requestBuilder.header("n-d-version-failover", new String[]{routeVersionFailover});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-transfer")) && StringUtils.isNotEmpty((CharSequence)(routeRegionTransfer = this.strategyContextHolder.getRouteRegionTransfer()))) {
                requestBuilder.header("n-d-region-transfer", new String[]{routeRegionTransfer});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-failover")) && StringUtils.isNotEmpty((CharSequence)(routeRegionFailover = this.strategyContextHolder.getRouteRegionFailover()))) {
                requestBuilder.header("n-d-region-failover", new String[]{routeRegionFailover});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-env-failover")) && StringUtils.isNotEmpty((CharSequence)(routeEnvironmentFailover = this.strategyContextHolder.getRouteEnvironmentFailover()))) {
                requestBuilder.header("n-d-env-failover", new String[]{routeEnvironmentFailover});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-zone-failover")) && StringUtils.isNotEmpty((CharSequence)(routeZoneFailover = this.strategyContextHolder.getRouteZoneFailover()))) {
                requestBuilder.header("n-d-zone-failover", new String[]{routeZoneFailover});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address-failover")) && StringUtils.isNotEmpty((CharSequence)(routeAddressFailover = this.strategyContextHolder.getRouteAddressFailover()))) {
                requestBuilder.header("n-d-address-failover", new String[]{routeAddressFailover});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-id-blacklist")) && StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getRouteIdBlacklist()))) {
                requestBuilder.header("n-d-id-blacklist", new String[]{routeIdBlacklist});
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address-blacklist")) && StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getRouteAddressBlacklist()))) {
                requestBuilder.header("n-d-address-blacklist", new String[]{routeAddressBlacklist});
            }
        }
    }

    private void interceptOutputHeader(ClientRequest request) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("------ WebClient Intercept Output Header Information -------").append("\n");
        HttpHeaders headers = request.headers();
        for (Map.Entry header : headers.entrySet()) {
            String headerName = (String)header.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            List headerValue = (List)header.getValue();
            stringBuilder.append(headerName + "=" + headerValue).append("\n");
        }
        stringBuilder.append("------------------------------------------------------------");
        LOG.info(stringBuilder.toString());
    }

    @Override
    protected InterceptorType getInterceptorType() {
        return InterceptorType.WEB_CLIENT;
    }

    @Override
    protected Logger getInterceptorLogger() {
        return LOG;
    }
}

