/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.context;

import com.nepxion.discovery.common.entity.HeadersInjectorType;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.strategy.injector.StrategyHeadersInjector;
import com.nepxion.discovery.plugin.strategy.injector.StrategyHeadersResolver;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;

public class StrategyHeaderContext {
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired(required=false)
    private List<StrategyHeadersInjector> strategyHeadersInjectorList;
    private List<String> requestHeaderNameList;

    @PostConstruct
    public void initialize() {
        this.requestHeaderNameList = new ArrayList<String>();
        String contextRequestHeaders = this.environment.getProperty("spring.application.strategy.context.request.headers");
        String businessRequestHeaders = this.environment.getProperty("spring.application.strategy.business.request.headers");
        List<String> injectorRequestHeaders = StrategyHeadersResolver.getInjectedHeaders(this.strategyHeadersInjectorList, HeadersInjectorType.TRANSMISSION);
        if (StringUtils.isNotEmpty((CharSequence)contextRequestHeaders)) {
            this.requestHeaderNameList.addAll(StringUtil.splitToList((String)contextRequestHeaders.toLowerCase()));
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRequestHeaders)) {
            this.requestHeaderNameList.addAll(StringUtil.splitToList((String)businessRequestHeaders.toLowerCase()));
        }
        if (CollectionUtils.isNotEmpty(injectorRequestHeaders)) {
            this.requestHeaderNameList.addAll(injectorRequestHeaders);
        }
    }

    public List<String> getRequestHeaderNameList() {
        return this.requestHeaderNameList;
    }
}

