/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.extractor;

import com.nepxion.discovery.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class StrategyPackagesExtractor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(StrategyPackagesExtractor.class);
    private ApplicationContext applicationContext;
    private Environment environment;
    private List<String> basePackagesList;
    private List<String> scanningPackagesList;
    private Set<String> scanningPackagesSet;
    private List<String> allPackagesList;
    private String basePackages;
    private String scanningPackages;
    private String allPackages;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        Boolean autoScanPackagesEnabled = (Boolean)this.environment.getProperty("spring.application.strategy.auto.scan.packages.enabled", Boolean.class, (Object)Boolean.TRUE);
        if (!autoScanPackagesEnabled.booleanValue()) {
            return;
        }
        try {
            this.allPackagesList = new ArrayList<String>();
            this.basePackagesList = this.getComponentBasePackages();
            if (CollectionUtils.isNotEmpty(this.basePackagesList)) {
                this.basePackages = StringUtil.convertToString(this.basePackagesList);
                for (String pkg : this.basePackagesList) {
                    if (this.allPackagesList.contains(pkg)) continue;
                    this.allPackagesList.add(pkg);
                }
            }
            this.scanningPackagesSet = this.getComponentScanningPackages(registry, this.basePackagesList);
            if (CollectionUtils.isNotEmpty(this.scanningPackagesSet)) {
                this.scanningPackagesList = new ArrayList<String>(this.scanningPackagesSet);
                this.scanningPackages = StringUtil.convertToString(this.scanningPackagesList);
                for (String pkg : this.scanningPackagesList) {
                    if (this.allPackagesList.contains(pkg)) continue;
                    this.allPackagesList.add(pkg);
                }
            }
            if (CollectionUtils.isNotEmpty(this.allPackagesList)) {
                this.allPackages = StringUtil.convertToString(this.allPackagesList);
            }
            LOG.info("--------- Auto Scan Packages Information ---------");
            LOG.info("Base packages is {}", this.basePackagesList);
            LOG.info("Scanning packages is {}", this.scanningPackagesList);
            LOG.info("All packages is {}", this.allPackagesList);
            LOG.info("--------------------------------------------------");
        }
        catch (Exception e) {
            LOG.warn("Get base and scanning packages failed, skip it...");
        }
    }

    public List<String> getBasePackagesList() {
        return this.basePackagesList;
    }

    public List<String> getScanningPackagesList() {
        return this.scanningPackagesList;
    }

    public List<String> getAllPackagesList() {
        return this.allPackagesList;
    }

    public String getBasePackages() {
        return this.basePackages;
    }

    public String getScanningPackages() {
        return this.scanningPackages;
    }

    public String getAllPackages() {
        return this.allPackages;
    }

    protected List<String> getComponentBasePackages() {
        return AutoConfigurationPackages.get((BeanFactory)this.applicationContext);
    }

    protected Set<String> getComponentScanningPackages(BeanDefinitionRegistry registry, List<String> basePackages) {
        String[] names;
        if (CollectionUtils.isEmpty(basePackages)) {
            return null;
        }
        Boolean autoScanRecursionEnabled = (Boolean)this.environment.getProperty("spring.application.strategy.auto.scan.recursion.enabled", Boolean.class, (Object)Boolean.FALSE);
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        block0: for (String name : names = registry.getBeanDefinitionNames()) {
            AnnotatedBeanDefinition annotatedDefinition;
            BeanDefinition definition = registry.getBeanDefinition(name);
            String beanClassName = definition.getBeanClassName();
            if (!(definition instanceof AnnotatedBeanDefinition) || beanClassName == null) continue;
            String beanPackage = ClassUtils.getPackageName((String)beanClassName);
            for (String pkg : basePackages) {
                if (!beanPackage.equals(pkg) && !beanPackage.startsWith(pkg + '.')) continue;
                annotatedDefinition = (AnnotatedBeanDefinition)definition;
                this.addComponentScanningPackages(packages, annotatedDefinition.getMetadata());
                break;
            }
            if (!autoScanRecursionEnabled.booleanValue()) continue;
            for (String pkg : packages) {
                if (!beanPackage.equals(pkg) && !beanPackage.startsWith(pkg + '.')) continue;
                annotatedDefinition = (AnnotatedBeanDefinition)definition;
                this.addComponentScanningPackages(packages, annotatedDefinition.getMetadata());
                continue block0;
            }
        }
        return packages;
    }

    private void addComponentScanningPackages(Set<String> packages, AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
        if (attributes != null) {
            this.addPackages(packages, attributes.getStringArray("value"));
            this.addPackages(packages, attributes.getStringArray("basePackages"));
            this.addClasses(packages, attributes.getStringArray("basePackageClasses"));
            if (packages.isEmpty()) {
                packages.add(ClassUtils.getPackageName((String)metadata.getClassName()));
            }
        }
    }

    private void addPackages(Set<String> packages, String[] values) {
        if (values != null) {
            Collections.addAll(packages, values);
        }
    }

    private void addClasses(Set<String> packages, String[] values) {
        if (values != null) {
            for (String value : values) {
                packages.add(ClassUtils.getPackageName((String)value));
            }
        }
    }
}

