/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.entity.VersionSortEntity;
import com.nepxion.discovery.common.entity.VersionSortType;
import com.nepxion.discovery.common.util.VersionSortUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.nepxion.discovery.plugin.strategy.filter.StrategyEnabledFilter;
import com.nepxion.discovery.plugin.strategy.matcher.DiscoveryMatcher;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractStrategyEnabledFilter
implements StrategyEnabledFilter {
    @Autowired
    protected DiscoveryMatcher discoveryMatcher;
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected PluginContextHolder pluginContextHolder;
    @Value(value="${spring.application.strategy.version.sort.type:version}")
    protected String sortType;

    @Override
    public void filter(List<? extends Server> servers) {
        Iterator<? extends Server> iterator = servers.iterator();
        while (iterator.hasNext()) {
            Server server = iterator.next();
            boolean enabled = this.apply(servers, server);
            if (enabled) continue;
            iterator.remove();
        }
    }

    public boolean findByGroup(List<? extends Server> servers, String group) {
        for (Server server : servers) {
            String serverGroup = this.pluginAdapter.getServerGroup(server);
            if (!StringUtils.equals((CharSequence)group, (CharSequence)serverGroup)) continue;
            return true;
        }
        return false;
    }

    public boolean findByVersion(List<? extends Server> servers, String version) {
        for (Server server : servers) {
            String serverVersion = this.pluginAdapter.getServerVersion(server);
            if (!StringUtils.equals((CharSequence)version, (CharSequence)serverVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean findByRegion(List<? extends Server> servers, String region) {
        for (Server server : servers) {
            String serverRegion = this.pluginAdapter.getServerRegion(server);
            if (!StringUtils.equals((CharSequence)region, (CharSequence)serverRegion)) continue;
            return true;
        }
        return false;
    }

    public boolean findByEnvironment(List<? extends Server> servers, String environment) {
        for (Server server : servers) {
            String serverEnvironment = this.pluginAdapter.getServerEnvironment(server);
            if (!StringUtils.equals((CharSequence)environment, (CharSequence)serverEnvironment)) continue;
            return true;
        }
        return false;
    }

    public boolean findByZone(List<? extends Server> servers, String zone) {
        for (Server server : servers) {
            String serverZone = this.pluginAdapter.getServerZone(server);
            if (!StringUtils.equals((CharSequence)zone, (CharSequence)serverZone)) continue;
            return true;
        }
        return false;
    }

    public boolean matchByVersion(List<? extends Server> servers, String versions) {
        for (Server server : servers) {
            String serverVersion = this.pluginAdapter.getServerVersion(server);
            if (!this.discoveryMatcher.match(versions, serverVersion, true)) continue;
            return true;
        }
        return false;
    }

    public boolean matchByRegion(List<? extends Server> servers, String regions) {
        for (Server server : servers) {
            String serverRegion = this.pluginAdapter.getServerRegion(server);
            if (!this.discoveryMatcher.match(regions, serverRegion, true)) continue;
            return true;
        }
        return false;
    }

    public boolean matchByAddress(List<? extends Server> servers, String addresses) {
        for (Server server : servers) {
            int serverPort;
            String serverHost = server.getHost();
            if (!this.discoveryMatcher.matchAddress(addresses, serverHost, serverPort = server.getPort(), true)) continue;
            return true;
        }
        return false;
    }

    public List<String> assembleVersionList(List<? extends Server> servers) {
        ArrayList<VersionSortEntity> versionSortEntityList = new ArrayList<VersionSortEntity>();
        for (Server server : servers) {
            String serverVersion = this.pluginAdapter.getServerVersion(server);
            String serverServiceUUId = this.pluginAdapter.getServerServiceUUId(server);
            VersionSortEntity versionSortEntity = new VersionSortEntity();
            versionSortEntity.setVersion(serverVersion);
            versionSortEntity.setServiceUUId(serverServiceUUId);
            versionSortEntityList.add(versionSortEntity);
        }
        VersionSortType versionSortType = VersionSortType.fromString((String)this.sortType);
        return VersionSortUtil.getVersionList(versionSortEntityList, (VersionSortType)versionSortType);
    }

    public DiscoveryMatcher getDiscoveryMatcher() {
        return this.discoveryMatcher;
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }

    public PluginContextHolder getPluginContextHolder() {
        return this.pluginContextHolder;
    }
}

