/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.strategy.filter.AbstractStrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class StrategyAddressEnabledFilter
extends AbstractStrategyEnabledFilter {
    @Value(value="${spring.application.strategy.address.failover.enabled:false}")
    protected Boolean addressFailoverEnabled;

    @Override
    public boolean apply(List<? extends Server> servers, Server server) {
        boolean matched;
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String addresses = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteAddress(), (String)serviceId);
        if (StringUtils.isEmpty((CharSequence)addresses)) {
            return true;
        }
        if (this.addressFailoverEnabled.booleanValue() && !(matched = this.matchByAddress(servers, addresses))) {
            String addressFailovers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteAddressFailover(), (String)serviceId);
            if (StringUtils.isEmpty((CharSequence)addressFailovers)) {
                return true;
            }
            return this.discoveryMatcher.matchAddress(addressFailovers, server.getHost(), server.getPort(), true);
        }
        return this.discoveryMatcher.matchAddress(addresses, server.getHost(), server.getPort(), true);
    }

    public int getOrder() {
        return -2147483643;
    }
}

