/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.strategy.filter.AbstractStrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class StrategyEnvironmentEnabledFilter
extends AbstractStrategyEnabledFilter {
    @Value(value="${spring.application.strategy.environment.failover.enabled:false}")
    protected Boolean environmentFailoverEnabled;

    @Override
    public boolean apply(List<? extends Server> servers, Server server) {
        String environment = this.pluginContextHolder.getContextRouteEnvironment();
        if (StringUtils.isEmpty((CharSequence)environment)) {
            return true;
        }
        String serverEnvironment = this.pluginAdapter.getServerEnvironment(server);
        boolean found = this.findByEnvironment(servers, environment);
        if (found) {
            return StringUtils.equals((CharSequence)serverEnvironment, (CharSequence)environment);
        }
        if (this.environmentFailoverEnabled.booleanValue()) {
            String serviceId = this.pluginAdapter.getServerServiceId(server);
            String environmentFailovers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteEnvironmentFailover(), (String)serviceId);
            if (StringUtils.isEmpty((CharSequence)environmentFailovers)) {
                environmentFailovers = "common";
            }
            return this.discoveryMatcher.match(environmentFailovers, serverEnvironment, true);
        }
        return StringUtils.equals((CharSequence)serverEnvironment, (CharSequence)environment);
    }

    public int getOrder() {
        return -2147483645;
    }
}

