/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.entity.ServiceType;
import com.nepxion.discovery.plugin.strategy.filter.AbstractStrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class StrategyGroupEnabledFilter
extends AbstractStrategyEnabledFilter {
    @Value(value="${spring.application.strategy.consumer.isolation.enabled:false}")
    protected Boolean consumerIsolationEnabled;

    @Override
    public boolean apply(List<? extends Server> servers, Server server) {
        if (!this.consumerIsolationEnabled.booleanValue()) {
            return true;
        }
        String serverServiceType = this.pluginAdapter.getServerServiceType(server);
        if (StringUtils.equals((CharSequence)serverServiceType, (CharSequence)ServiceType.GATEWAY.toString())) {
            return true;
        }
        String serverGroup = this.pluginAdapter.getServerGroup(server);
        String group = this.pluginAdapter.getGroup();
        return StringUtils.equals((CharSequence)serverGroup, (CharSequence)group);
    }

    public int getOrder() {
        return -2147483646;
    }
}

