/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.strategy.filter.AbstractStrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class StrategyRegionEnabledFilter
extends AbstractStrategyEnabledFilter {
    @Value(value="${spring.application.strategy.region.transfer.enabled:false}")
    protected Boolean regionTransferEnabled;
    @Value(value="${spring.application.strategy.region.failover.enabled:false}")
    protected Boolean regionFailoverEnabled;

    @Override
    public boolean apply(List<? extends Server> servers, Server server) {
        boolean matched;
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String region = this.pluginAdapter.getServerRegion(server);
        String regions = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteRegion(), (String)serviceId);
        if (StringUtils.isEmpty((CharSequence)regions)) {
            if (this.regionTransferEnabled.booleanValue()) {
                String regionTransfers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteRegionTransfer(), (String)serviceId);
                if (StringUtils.isEmpty((CharSequence)regionTransfers)) {
                    throw new DiscoveryException("The Region Transfer value is missing");
                }
                return this.discoveryMatcher.match(regionTransfers, region, true);
            }
            return true;
        }
        if (this.regionFailoverEnabled.booleanValue() && !(matched = this.matchByRegion(servers, regions))) {
            boolean isServerActive = this.pluginAdapter.isServerActive(server);
            if (isServerActive) {
                return false;
            }
            String regionFailovers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteRegionFailover(), (String)serviceId);
            if (StringUtils.isEmpty((CharSequence)regionFailovers)) {
                return true;
            }
            return this.discoveryMatcher.match(regionFailovers, region, true);
        }
        return this.discoveryMatcher.match(regions, region, true);
    }

    public int getOrder() {
        return -2147483642;
    }
}

