/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.strategy.adapter.StrategyVersionFilterAdapter;
import com.nepxion.discovery.plugin.strategy.filter.AbstractStrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StrategyVersionEnabledFilter
extends AbstractStrategyEnabledFilter {
    @Autowired
    protected StrategyVersionFilterAdapter strategyVersionFilterAdapter;
    @Value(value="${spring.application.strategy.version.failover.enabled:false}")
    protected Boolean versionFailoverEnabled;
    @Value(value="${spring.application.strategy.version.failover.stable.enabled:false}")
    protected Boolean versionFailoverStableEnabled;
    @Value(value="${spring.application.strategy.version.prefer.enabled:false}")
    protected Boolean versionPreferEnabled;

    @Override
    public boolean apply(List<? extends Server> servers, Server server) {
        boolean matched;
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String version = this.pluginAdapter.getServerVersion(server);
        String versions = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteVersion(), (String)serviceId);
        if (StringUtils.isEmpty((CharSequence)versions)) {
            if (this.versionPreferEnabled.booleanValue()) {
                String versionPrefers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteVersionPrefer(), (String)serviceId);
                if (StringUtils.isEmpty((CharSequence)versionPrefers)) {
                    return this.containVersion(servers, server);
                }
                return this.discoveryMatcher.match(versionPrefers, version, true);
            }
            return true;
        }
        if (this.versionFailoverEnabled.booleanValue() && !(matched = this.matchByVersion(servers, versions))) {
            String versionFailovers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteVersionFailover(), (String)serviceId);
            if (StringUtils.isEmpty((CharSequence)versionFailovers)) {
                if (this.versionFailoverStableEnabled.booleanValue()) {
                    return this.containVersion(servers, server);
                }
                return true;
            }
            return this.discoveryMatcher.match(versionFailovers, version, true);
        }
        return this.discoveryMatcher.match(versions, version, true);
    }

    public boolean containVersion(List<? extends Server> servers, Server server) {
        String version = this.pluginAdapter.getServerVersion(server);
        if (StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            return true;
        }
        List<String> versionList = this.assembleVersionList(servers);
        if (versionList.size() <= 1) {
            return true;
        }
        List<String> filterVersionList = this.strategyVersionFilterAdapter.filter(versionList);
        return filterVersionList.contains(version);
    }

    public int getOrder() {
        return -2147483641;
    }
}

