/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.strategy.filter.AbstractStrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class StrategyZoneEnabledFilter
extends AbstractStrategyEnabledFilter {
    @Value(value="${spring.application.strategy.zone.affinity.enabled:false}")
    protected Boolean zoneAffinityEnabled;
    @Value(value="${spring.application.strategy.zone.failover.enabled:false}")
    protected Boolean zoneFailoverEnabled;

    @Override
    public boolean apply(List<? extends Server> servers, Server server) {
        if (!this.zoneAffinityEnabled.booleanValue()) {
            return true;
        }
        String zone = this.pluginAdapter.getZone();
        String serverZone = this.pluginAdapter.getServerZone(server);
        boolean found = this.findByZone(servers, zone);
        if (found) {
            return StringUtils.equals((CharSequence)serverZone, (CharSequence)zone);
        }
        if (this.zoneFailoverEnabled.booleanValue()) {
            String serviceId = this.pluginAdapter.getServerServiceId(server);
            String zoneFailovers = JsonUtil.fromJsonMap((String)this.pluginContextHolder.getContextRouteZoneFailover(), (String)serviceId);
            if (StringUtils.isEmpty((CharSequence)zoneFailovers)) {
                return true;
            }
            return this.discoveryMatcher.match(zoneFailovers, serverZone, true);
        }
        return StringUtils.equals((CharSequence)serverZone, (CharSequence)zone);
    }

    public int getOrder() {
        return -2147483644;
    }
}

