/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.matcher;

import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.strategy.matcher.DiscoveryMatcherStrategy;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscoveryMatcher {
    @Autowired
    protected DiscoveryMatcherStrategy discoveryMatcherStrategy;

    public boolean match(String targetValues, String value, boolean returnValue) {
        List targetValueList = StringUtil.splitToList((String)targetValues);
        if (targetValueList.contains(value)) {
            return returnValue;
        }
        for (String targetValuePattern : targetValueList) {
            if (!this.discoveryMatcherStrategy.match(targetValuePattern, value)) continue;
            return returnValue;
        }
        return !returnValue;
    }

    public boolean matchAddress(String addresses, String host, int port, boolean returnValue) {
        List addressList = StringUtil.splitToList((String)addresses);
        if (addressList.contains(host + ":" + port) || addressList.contains(host) || addressList.contains(String.valueOf(port))) {
            return returnValue;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, host + ":" + port) && !this.discoveryMatcherStrategy.match(addressPattern, host) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(port))) continue;
            return returnValue;
        }
        return !returnValue;
    }
}

