/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.monitor;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyTracer;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyTracerContext;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractStrategyTracer<S>
implements StrategyTracer {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyMonitorContext strategyMonitorContext;
    @Value(value="${spring.application.strategy.tracer.enabled:false}")
    protected Boolean tracerEnabled;
    @Value(value="${spring.application.strategy.tracer.separate.span.enabled:true}")
    protected Boolean tracerSeparateSpanEnabled;
    @Value(value="${spring.application.strategy.tracer.rule.output.enabled:true}")
    protected Boolean tracerRuleOutputEnabled;
    @Value(value="${spring.application.strategy.tracer.span.value:NEPXION}")
    protected String tracerSpanValue;
    @Value(value="${spring.application.strategy.tracer.span.tag.plugin.value:Nepxion Discovery}")
    protected String tracerSpanPluginValue;

    @Override
    public void spanBuild() {
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        if (!this.tracerSeparateSpanEnabled.booleanValue()) {
            return;
        }
        S span = this.buildSpan();
        StrategyTracerContext.getCurrentContext().setSpan(span);
    }

    @Override
    public void spanOutput(Map<String, String> contextMap) {
        Map<String, String> map;
        List<String> tracerInjectorHeaderNameList;
        String zone;
        String environment;
        String region;
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        S span = this.getCurrentSpan();
        if (span == null) {
            return;
        }
        if (this.tracerSeparateSpanEnabled.booleanValue()) {
            this.outputSpan(span, "plugin", this.tracerSpanPluginValue);
        }
        this.outputSpan(span, "trace-id", this.toTraceId(span));
        this.outputSpan(span, "span-id", this.toSpanId(span));
        this.outputSpan(span, "n-d-service-group", this.pluginAdapter.getGroup());
        this.outputSpan(span, "n-d-service-type", this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            this.outputSpan(span, "n-d-service-app-id", serviceAppId);
        }
        this.outputSpan(span, "n-d-service-id", this.pluginAdapter.getServiceId());
        this.outputSpan(span, "n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            this.outputSpan(span, "n-d-service-version", version);
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            this.outputSpan(span, "n-d-service-region", region);
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            this.outputSpan(span, "n-d-service-env", environment);
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            this.outputSpan(span, "n-d-service-zone", zone);
        }
        if (this.tracerRuleOutputEnabled.booleanValue()) {
            String routeAddressBlacklist;
            String routeIdBlacklist;
            String routeAddressFailover;
            String routeZoneFailover;
            String routeEnvironmentFailover;
            String routeRegionFailover;
            String routeRegionTransfer;
            String routeVersionFailover;
            String routeVersionPrefer;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String string;
            String routeVersion = this.strategyContextHolder.getHeader("n-d-version");
            if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
                this.outputSpan(span, "n-d-version", routeVersion);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string = this.strategyContextHolder.getHeader("n-d-region")))) {
                this.outputSpan(span, "n-d-region", string);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getHeader("n-d-env")))) {
                this.outputSpan(span, "n-d-env", routeEnvironment);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getHeader("n-d-address")))) {
                this.outputSpan(span, "n-d-address", routeAddress);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getHeader("n-d-version-weight")))) {
                this.outputSpan(span, "n-d-version-weight", routeVersionWeight);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getHeader("n-d-region-weight")))) {
                this.outputSpan(span, "n-d-region-weight", routeRegionWeight);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeVersionPrefer = this.strategyContextHolder.getHeader("n-d-version-prefer")))) {
                this.outputSpan(span, "n-d-version-prefer", routeVersionPrefer);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeVersionFailover = this.strategyContextHolder.getHeader("n-d-version-failover")))) {
                this.outputSpan(span, "n-d-version-failover", routeVersionFailover);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeRegionTransfer = this.strategyContextHolder.getHeader("n-d-region-transfer")))) {
                this.outputSpan(span, "n-d-region-transfer", routeRegionTransfer);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeRegionFailover = this.strategyContextHolder.getHeader("n-d-region-failover")))) {
                this.outputSpan(span, "n-d-region-failover", routeRegionFailover);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeEnvironmentFailover = this.strategyContextHolder.getHeader("n-d-env-failover")))) {
                this.outputSpan(span, "n-d-env-failover", routeEnvironmentFailover);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeZoneFailover = this.strategyContextHolder.getHeader("n-d-zone-failover")))) {
                this.outputSpan(span, "n-d-zone-failover", routeZoneFailover);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeAddressFailover = this.strategyContextHolder.getHeader("n-d-address-failover")))) {
                this.outputSpan(span, "n-d-address-failover", routeAddressFailover);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getHeader("n-d-id-blacklist")))) {
                this.outputSpan(span, "n-d-id-blacklist", routeIdBlacklist);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getHeader("n-d-address-blacklist")))) {
                this.outputSpan(span, "n-d-address-blacklist", routeAddressBlacklist);
            }
        }
        if (MapUtils.isNotEmpty(contextMap)) {
            for (Map.Entry entry : contextMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                this.outputSpan(span, key, value);
            }
        }
        if (CollectionUtils.isNotEmpty(tracerInjectorHeaderNameList = this.strategyMonitorContext.getTracerInjectorHeaderNameList())) {
            for (String tracerInjectorHeaderName : tracerInjectorHeaderNameList) {
                String tracerInjectorHeaderValue = this.strategyContextHolder.getHeader(tracerInjectorHeaderName);
                if (!StringUtils.isNotEmpty((CharSequence)tracerInjectorHeaderValue)) continue;
                this.outputSpan(span, tracerInjectorHeaderName, tracerInjectorHeaderValue);
            }
        }
        if (MapUtils.isNotEmpty(map = this.strategyMonitorContext.getTracerCustomizationMap())) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                this.outputSpan(span, key, value);
            }
        }
    }

    @Override
    public void spanError(Throwable e) {
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        if (!this.tracerSeparateSpanEnabled.booleanValue()) {
            return;
        }
        S span = this.getCurrentSpan();
        if (span == null) {
            return;
        }
        this.errorSpan(span, e);
    }

    @Override
    public void spanFinish() {
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        if (!this.tracerSeparateSpanEnabled.booleanValue()) {
            return;
        }
        S span = this.getCurrentSpan();
        if (span != null) {
            this.finishSpan(span);
        }
        StrategyTracerContext.clearCurrentContext();
    }

    private S getCurrentSpan() {
        return (S)(this.tracerSeparateSpanEnabled != false ? StrategyTracerContext.getCurrentContext().getSpan() : this.getActiveSpan());
    }

    @Override
    public String getTraceId() {
        if (!this.tracerEnabled.booleanValue()) {
            return null;
        }
        S span = this.getCurrentSpan();
        if (span != null) {
            return this.toTraceId(span);
        }
        return null;
    }

    @Override
    public String getSpanId() {
        if (!this.tracerEnabled.booleanValue()) {
            return null;
        }
        S span = this.getCurrentSpan();
        if (span != null) {
            return this.toSpanId(span);
        }
        return null;
    }

    protected abstract S buildSpan();

    protected abstract void outputSpan(S var1, String var2, String var3);

    protected abstract void errorSpan(S var1, Throwable var2);

    protected abstract void finishSpan(S var1);

    protected abstract S getActiveSpan();

    protected abstract String toTraceId(S var1);

    protected abstract String toSpanId(S var1);
}

