/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.monitor;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.event.PluginPublisher;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.event.StrategyAlarmEvent;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyAlarm;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultStrategyAlarm
implements StrategyAlarm {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyMonitorContext strategyMonitorContext;
    @Autowired
    protected PluginPublisher pluginPublisher;
    @Value(value="${spring.application.strategy.alarm.enabled:false}")
    protected Boolean alarmEnabled;

    @Override
    public void alarm(Map<String, String> contextMap) {
        Map<String, String> map;
        List<String> tracerInjectorHeaderNameList;
        String routeAddressBlacklist;
        String routeIdBlacklist;
        String routeAddressFailover;
        String routeZoneFailover;
        String routeEnvironmentFailover;
        String routeRegionFailover;
        String routeRegionTransfer;
        String routeVersionFailover;
        String routeVersionPrefer;
        String routeRegionWeight;
        String routeVersionWeight;
        String routeAddress;
        String routeEnvironment;
        String routeRegion;
        String routeVersion;
        String zone;
        String environment;
        String region;
        if (!this.alarmEnabled.booleanValue()) {
            return;
        }
        LinkedHashMap<String, String> alarmMap = new LinkedHashMap<String, String>();
        String traceId = this.strategyMonitorContext.getTraceId();
        String spanId = this.strategyMonitorContext.getSpanId();
        if (StringUtils.isNotEmpty((CharSequence)traceId)) {
            alarmMap.put("trace-id", traceId);
        }
        if (StringUtils.isNotEmpty((CharSequence)spanId)) {
            alarmMap.put("span-id", spanId);
        }
        alarmMap.put("n-d-service-group", this.pluginAdapter.getGroup());
        alarmMap.put("n-d-service-type", this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            alarmMap.put("n-d-service-app-id", serviceAppId);
        }
        alarmMap.put("n-d-service-id", this.pluginAdapter.getServiceId());
        alarmMap.put("n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            alarmMap.put("n-d-service-version", version);
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            alarmMap.put("n-d-service-region", region);
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            alarmMap.put("n-d-service-env", environment);
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            alarmMap.put("n-d-service-zone", zone);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getHeader("n-d-version")))) {
            alarmMap.put("n-d-version", routeVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getHeader("n-d-region")))) {
            alarmMap.put("n-d-region", routeRegion);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getHeader("n-d-env")))) {
            alarmMap.put("n-d-env", routeEnvironment);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getHeader("n-d-address")))) {
            alarmMap.put("n-d-address", routeAddress);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getHeader("n-d-version-weight")))) {
            alarmMap.put("n-d-version-weight", routeVersionWeight);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getHeader("n-d-region-weight")))) {
            alarmMap.put("n-d-region-weight", routeRegionWeight);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionPrefer = this.strategyContextHolder.getHeader("n-d-version-prefer")))) {
            alarmMap.put("n-d-version-prefer", routeVersionPrefer);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionFailover = this.strategyContextHolder.getHeader("n-d-version-failover")))) {
            alarmMap.put("n-d-version-failover", routeVersionFailover);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionTransfer = this.strategyContextHolder.getHeader("n-d-region-transfer")))) {
            alarmMap.put("n-d-region-transfer", routeRegionTransfer);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionFailover = this.strategyContextHolder.getHeader("n-d-region-failover")))) {
            alarmMap.put("n-d-region-failover", routeRegionFailover);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeEnvironmentFailover = this.strategyContextHolder.getHeader("n-d-env-failover")))) {
            alarmMap.put("n-d-env-failover", routeEnvironmentFailover);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeZoneFailover = this.strategyContextHolder.getHeader("n-d-zone-failover")))) {
            alarmMap.put("n-d-zone-failover", routeZoneFailover);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddressFailover = this.strategyContextHolder.getHeader("n-d-address-failover")))) {
            alarmMap.put("n-d-address-failover", routeAddressFailover);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getHeader("n-d-id-blacklist")))) {
            alarmMap.put("n-d-id-blacklist", routeIdBlacklist);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getHeader("n-d-address-blacklist")))) {
            alarmMap.put("n-d-address-blacklist", routeAddressBlacklist);
        }
        if (MapUtils.isNotEmpty(contextMap)) {
            for (Map.Entry<String, String> entry : contextMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                alarmMap.put(key, value);
            }
        }
        if (CollectionUtils.isNotEmpty(tracerInjectorHeaderNameList = this.strategyMonitorContext.getTracerInjectorHeaderNameList())) {
            for (String tracerInjectorHeaderName : tracerInjectorHeaderNameList) {
                String tracerInjectorHeaderValue = this.strategyContextHolder.getHeader(tracerInjectorHeaderName);
                if (!StringUtils.isNotEmpty((CharSequence)tracerInjectorHeaderValue)) continue;
                alarmMap.put(tracerInjectorHeaderName, tracerInjectorHeaderValue);
            }
        }
        if (MapUtils.isNotEmpty(map = this.strategyMonitorContext.getTracerCustomizationMap())) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                alarmMap.put(key, value);
            }
        }
        this.onAlarm(alarmMap);
    }

    private void onAlarm(Map<String, String> alarmMap) {
        this.pluginPublisher.asyncPublish((Object)new StrategyAlarmEvent("strategy-context-alarm", alarmMap));
    }
}

