/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.monitor;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.context.StrategyHeaderContext;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyLogger;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultStrategyLogger
implements StrategyLogger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStrategyLogger.class);
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyMonitorContext strategyMonitorContext;
    @Autowired
    protected StrategyHeaderContext strategyHeaderContext;
    @Value(value="${spring.application.strategy.logger.enabled:false}")
    protected Boolean loggerEnabled;
    @Value(value="${spring.application.strategy.logger.mdc.key.shown:true}")
    protected Boolean loggerMdcKeyShown;
    @Value(value="${spring.application.strategy.logger.debug.enabled:false}")
    protected Boolean loggerDebugEnabled;

    @Override
    public void loggerOutput() {
        String zone;
        String environment;
        String region;
        if (!this.loggerEnabled.booleanValue()) {
            return;
        }
        String traceId = this.strategyMonitorContext.getTraceId();
        String spanId = this.strategyMonitorContext.getSpanId();
        if (StringUtils.isNotEmpty((CharSequence)traceId)) {
            MDC.put((String)"trace-id", (String)((this.loggerMdcKeyShown != false ? "trace-id=" : "") + traceId));
        }
        if (StringUtils.isNotEmpty((CharSequence)spanId)) {
            MDC.put((String)"span-id", (String)((this.loggerMdcKeyShown != false ? "span-id=" : "") + spanId));
        }
        MDC.put((String)"n-d-service-group", (String)((this.loggerMdcKeyShown != false ? "n-d-service-group=" : "") + this.pluginAdapter.getGroup()));
        MDC.put((String)"n-d-service-type", (String)((this.loggerMdcKeyShown != false ? "n-d-service-type=" : "") + this.pluginAdapter.getServiceType()));
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            MDC.put((String)"n-d-service-app-id", (String)((this.loggerMdcKeyShown != false ? "n-d-service-app-id=" : "") + serviceAppId));
        }
        MDC.put((String)"n-d-service-id", (String)((this.loggerMdcKeyShown != false ? "n-d-service-id=" : "") + this.pluginAdapter.getServiceId()));
        MDC.put((String)"n-d-service-address", (String)((this.loggerMdcKeyShown != false ? "n-d-service-address=" : "") + this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()));
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            MDC.put((String)"n-d-service-version", (String)((this.loggerMdcKeyShown != false ? "n-d-service-version=" : "") + version));
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            MDC.put((String)"n-d-service-region", (String)((this.loggerMdcKeyShown != false ? "n-d-service-region=" : "") + region));
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            MDC.put((String)"n-d-service-env", (String)((this.loggerMdcKeyShown != false ? "n-d-service-env=" : "") + environment));
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            MDC.put((String)"n-d-service-zone", (String)((this.loggerMdcKeyShown != false ? "n-d-service-zone=" : "") + zone));
        }
    }

    @Override
    public void loggerClear() {
        if (!this.loggerEnabled.booleanValue()) {
            return;
        }
        MDC.clear();
    }

    @Override
    public void loggerDebug() {
        List<String> requestHeaderNameList;
        String routeAddressBlacklist;
        String routeIdBlacklist;
        String routeAddressFailover;
        String routeZoneFailover;
        String routeEnvironmentFailover;
        String routeRegionFailover;
        String routeRegionTransfer;
        String routeVersionFailover;
        String routeVersionPrefer;
        String routeRegionWeight;
        String routeVersionWeight;
        String routeAddress;
        String routeEnvironment;
        String routeRegion;
        String routeVersion;
        String zone;
        String environment;
        String region;
        if (!this.loggerDebugEnabled.booleanValue()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("--------------- Strategy Logger Information ----------------").append("\n");
        String traceId = this.strategyMonitorContext.getTraceId();
        String spanId = this.strategyMonitorContext.getSpanId();
        if (StringUtils.isNotEmpty((CharSequence)traceId)) {
            stringBuilder.append("trace-id=" + traceId).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)spanId)) {
            stringBuilder.append("span-id=" + spanId).append("\n");
        }
        stringBuilder.append("n-d-service-group=" + this.pluginAdapter.getGroup()).append("\n");
        stringBuilder.append("n-d-service-type=" + this.pluginAdapter.getServiceType()).append("\n");
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            stringBuilder.append("n-d-service-app-id=" + serviceAppId).append("\n");
        }
        stringBuilder.append("n-d-service-id=" + this.pluginAdapter.getServiceId()).append("\n");
        stringBuilder.append("n-d-service-address=" + this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()).append("\n");
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            stringBuilder.append("n-d-service-version=" + version).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            stringBuilder.append("n-d-service-region=" + region).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            stringBuilder.append("n-d-service-env=" + environment).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            stringBuilder.append("n-d-service-zone=" + zone).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getHeader("n-d-version")))) {
            stringBuilder.append("n-d-version=" + routeVersion).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getHeader("n-d-region")))) {
            stringBuilder.append("n-d-region=" + routeRegion).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getHeader("n-d-env")))) {
            stringBuilder.append("n-d-env=" + routeEnvironment).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getHeader("n-d-address")))) {
            stringBuilder.append("n-d-address=" + routeAddress).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getHeader("n-d-version-weight")))) {
            stringBuilder.append("n-d-version-weight=" + routeVersionWeight).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getHeader("n-d-region-weight")))) {
            stringBuilder.append("n-d-region-weight=" + routeRegionWeight).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionPrefer = this.strategyContextHolder.getHeader("n-d-version-prefer")))) {
            stringBuilder.append("n-d-version-prefer=" + routeVersionPrefer).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionFailover = this.strategyContextHolder.getHeader("n-d-version-failover")))) {
            stringBuilder.append("n-d-version-failover=" + routeVersionFailover).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionTransfer = this.strategyContextHolder.getHeader("n-d-region-transfer")))) {
            stringBuilder.append("n-d-region-transfer=" + routeRegionTransfer).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionFailover = this.strategyContextHolder.getHeader("n-d-region-failover")))) {
            stringBuilder.append("n-d-region-failover=" + routeRegionFailover).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeEnvironmentFailover = this.strategyContextHolder.getHeader("n-d-env-failover")))) {
            stringBuilder.append("n-d-env-failover=" + routeEnvironmentFailover).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeZoneFailover = this.strategyContextHolder.getHeader("n-d-zone-failover")))) {
            stringBuilder.append("n-d-zone-failover=" + routeZoneFailover).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddressFailover = this.strategyContextHolder.getHeader("n-d-address-failover")))) {
            stringBuilder.append("n-d-address-failover=" + routeAddressFailover).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getHeader("n-d-id-blacklist")))) {
            stringBuilder.append("n-d-id-blacklist=" + routeIdBlacklist).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getHeader("n-d-address-blacklist")))) {
            stringBuilder.append("n-d-address-blacklist=" + routeAddressBlacklist).append("\n");
        }
        if (CollectionUtils.isNotEmpty(requestHeaderNameList = this.strategyHeaderContext.getRequestHeaderNameList())) {
            for (String requestHeaderName : requestHeaderNameList) {
                String requestHeaderValue = this.strategyContextHolder.getHeader(requestHeaderName);
                if (!StringUtils.isNotEmpty((CharSequence)requestHeaderValue)) continue;
                stringBuilder.append(requestHeaderName + "=" + requestHeaderValue).append("\n");
            }
        }
        stringBuilder.append("------------------------------------------------------------");
        LOG.info(stringBuilder.toString());
    }
}

