/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.matrix.proxy.aop;

import com.nepxion.matrix.proxy.exception.ProxyException;
import com.nepxion.matrix.proxy.util.ProxyUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public abstract class AbstractInterceptor
implements MethodInterceptor {
    private ParameterNameDiscoverer standardReflectionParameterNameDiscoverer = new StandardReflectionParameterNameDiscoverer();
    private ParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public boolean isCglibAopProxy(MethodInvocation invocation) {
        return this.getProxyClassName(invocation).contains("Cglib");
    }

    public String getProxyType(MethodInvocation invocation) {
        boolean isCglibAopProxy = this.isCglibAopProxy(invocation);
        if (isCglibAopProxy) {
            return "Cglib Aop Proxy";
        }
        return "Reflective Aop Proxy";
    }

    public Class<?> getProxyClass(MethodInvocation invocation) {
        return invocation.getClass();
    }

    public String getProxyClassName(MethodInvocation invocation) {
        return this.getProxyClass(invocation).getCanonicalName();
    }

    public Object getProxiedObject(MethodInvocation invocation) {
        return invocation.getThis();
    }

    public Class<?> getProxiedClass(MethodInvocation invocation) {
        return this.getProxiedObject(invocation).getClass();
    }

    public String getProxiedClassName(MethodInvocation invocation) {
        return this.getProxiedClass(invocation).getCanonicalName();
    }

    public Class<?>[] getProxiedInterfaces(MethodInvocation invocation) {
        return this.getProxiedClass(invocation).getInterfaces();
    }

    public Annotation[] getProxiedClassAnnotations(MethodInvocation invocation) {
        return this.getProxiedClass(invocation).getAnnotations();
    }

    public Method getMethod(MethodInvocation invocation) {
        return invocation.getMethod();
    }

    public String getMethodName(MethodInvocation invocation) {
        return this.getMethod(invocation).getName();
    }

    public Annotation[][] getMethodParameterAnnotations(MethodInvocation invocation) {
        return this.getMethod(invocation).getParameterAnnotations();
    }

    public Class<?>[] getMethodParameterTypes(MethodInvocation invocation) {
        return this.getMethod(invocation).getParameterTypes();
    }

    public String getMethodParameterTypesValue(MethodInvocation invocation) {
        Class<?>[] parameterTypes = this.getMethodParameterTypes(invocation);
        String parameterTypesValue = ProxyUtil.toString(parameterTypes);
        return parameterTypesValue;
    }

    public String[] getMethodParameterNames(MethodInvocation invocation) {
        Method method = this.getMethod(invocation);
        boolean isCglibAopProxy = this.isCglibAopProxy(invocation);
        if (isCglibAopProxy) {
            return this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        }
        return this.standardReflectionParameterNameDiscoverer.getParameterNames(method);
    }

    public Annotation[] getMethodAnnotations(MethodInvocation invocation) {
        return this.getMethod(invocation).getAnnotations();
    }

    public Object[] getArguments(MethodInvocation invocation) {
        return invocation.getArguments();
    }

    public <T> T getValueByParameterAnnotation(MethodInvocation invocation, Class<?> parameterAnnotationType, Class<T> parameterType) {
        String methodName = this.getMethodName(invocation);
        String parameterTypesValue = this.getMethodParameterTypesValue(invocation);
        Annotation[][] parameterAnnotations = this.getMethodParameterAnnotations(invocation);
        Object[] arguments = this.getArguments(invocation);
        if (ArrayUtils.isEmpty((Object[])parameterAnnotations)) {
            throw new ProxyException("Not found any annotations");
        }
        Object value = null;
        int annotationIndex = 0;
        int valueIndex = 0;
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = annotationArray[i]) {
                if (annotation.annotationType() != parameterAnnotationType) continue;
                if (value != null) {
                    throw new ProxyException("Only 1 annotation=" + parameterAnnotationType.getName() + " can be added in method [name=" + methodName + ", parameterTypes=" + parameterTypesValue + "]");
                }
                Object object = arguments[valueIndex];
                if (object == null) {
                    throw new ProxyException("Value for annotation=" + parameterAnnotationType.getName() + " in method [name=" + methodName + ", parameterTypes=" + parameterTypesValue + "] is null");
                }
                if (object.getClass() != parameterType) {
                    throw new ProxyException("Type for annotation=" + parameterAnnotationType.getName() + " in method [name=" + methodName + ", parameterTypes=" + parameterTypesValue + "] must be " + parameterType.getName());
                }
                value = object;
                ++annotationIndex;
            }
            ++valueIndex;
        }
        if (annotationIndex == 0) {
            return null;
        }
        return (T)value;
    }

    public String getSpelKey(MethodInvocation invocation, String key) {
        String[] parameterNames = this.getMethodParameterNames(invocation);
        Object[] arguments = this.getArguments(invocation);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], arguments[i]);
        }
        return (String)parser.parseExpression(key).getValue((EvaluationContext)context, String.class);
    }
}

