/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml;

import com.fasterxml.jackson.databind.JsonNode;
import com.nerdforge.unxml.factory.ArrayNodeParserBuilderFactory;
import com.nerdforge.unxml.factory.ObjectArrayParserBuilderFactory;
import com.nerdforge.unxml.json.JsonUtil;
import com.nerdforge.unxml.parsers.Parser;
import com.nerdforge.unxml.parsers.SimpleParsers;
import com.nerdforge.unxml.parsers.builders.ArrayNodeParserBuilder;
import com.nerdforge.unxml.parsers.builders.ObjectArrayParserBuilder;
import com.nerdforge.unxml.parsers.builders.ObjectNodeParserBuilder;
import com.nerdforge.unxml.parsers.builders.ParserBuilder;
import com.nerdforge.unxml.xml.XmlUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;

public class Parsing {
    private final ArrayNodeParserBuilderFactory arrayNodeFactory;
    private final SimpleParsers simpleParsers;
    private Provider<ObjectNodeParserBuilder> objectParserBuilder;
    private final XmlUtil xmlUtil;
    private final JsonUtil jsonUtil;
    private final ObjectArrayParserBuilderFactory objectArrayParserBuilderFactory;

    @Inject
    public Parsing(ArrayNodeParserBuilderFactory arrayNodeFactory, SimpleParsers simpleParsers, Provider<ObjectNodeParserBuilder> objectParserBuilder, XmlUtil xmlUtil, JsonUtil jsonUtil, ObjectArrayParserBuilderFactory objectArrayParserBuilderFactory) {
        this.arrayNodeFactory = arrayNodeFactory;
        this.simpleParsers = simpleParsers;
        this.objectParserBuilder = objectParserBuilder;
        this.xmlUtil = xmlUtil;
        this.jsonUtil = jsonUtil;
        this.objectArrayParserBuilderFactory = objectArrayParserBuilderFactory;
    }

    public ObjectNodeParserBuilder obj() {
        return (ObjectNodeParserBuilder)this.objectParserBuilder.get();
    }

    public ObjectNodeParserBuilder obj(String xpath) {
        return ((ObjectNodeParserBuilder)this.objectParserBuilder.get()).xpath(xpath);
    }

    public ObjectArrayParserBuilder arr(String xpath) {
        return this.objectArrayParserBuilderFactory.create(xpath);
    }

    public ArrayNodeParserBuilder arr(String xpath, ParserBuilder builder) {
        return this.arrayNodeFactory.create(xpath, builder.build());
    }

    public ArrayNodeParserBuilder arr(String xpath, Parser<?> parser) {
        return this.arrayNodeFactory.create(xpath, parser);
    }

    public Parser<JsonNode> text() {
        return this.simpleParsers.textParser();
    }

    public Parser<JsonNode> number() {
        return this.simpleParsers.numberParser();
    }

    public Parser<JsonNode> with(Function<String, Object> transformer) {
        return this.simpleParsers.textParser(transformer);
    }

    public Parser<JsonNode> with(Supplier<Parser<?>> supplier) {
        return node -> (JsonNode)((Parser)supplier.get()).apply(node);
    }

    public XmlUtil xml() {
        return this.xmlUtil;
    }

    public JsonUtil json() {
        return this.jsonUtil;
    }

    public SimpleParsers simple() {
        return this.simpleParsers;
    }
}

