/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.inject.PrivateModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import com.nerdforge.unxml.Parsing;
import com.nerdforge.unxml.factory.ArrayNodeParserBuilderFactory;
import com.nerdforge.unxml.factory.ArrayNodeParserFactory;
import com.nerdforge.unxml.factory.ObjectArrayParserBuilderFactory;
import com.nerdforge.unxml.factory.ObjectNodeParserFactory;
import com.nerdforge.unxml.parsers.ArrayNodeParser;
import com.nerdforge.unxml.parsers.ObjectNodeParser;
import com.nerdforge.unxml.parsers.SimpleParsers;
import com.nerdforge.unxml.parsers.builders.ArrayNodeParserBuilder;
import com.nerdforge.unxml.parsers.builders.ObjectArrayParserBuilder;
import com.nerdforge.unxml.xml.LoggingErrorHandler;
import com.nerdforge.unxml.xml.SimpleNamespaceContext;
import com.nerdforge.unxml.xml.XmlUtil;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

public class UnXmlModule
extends PrivateModule {
    Map<String, String> namespaces = new HashMap<String, String>();

    public UnXmlModule() {
    }

    public UnXmlModule(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(ObjectNodeParser.class, ObjectNodeParser.class).build(ObjectNodeParserFactory.class));
        this.install(new FactoryModuleBuilder().implement(ArrayNodeParser.class, ArrayNodeParser.class).build(ArrayNodeParserFactory.class));
        this.install(new FactoryModuleBuilder().implement(ArrayNodeParserBuilder.class, ArrayNodeParserBuilder.class).build(ArrayNodeParserBuilderFactory.class));
        this.install(new FactoryModuleBuilder().implement(ObjectArrayParserBuilder.class, ObjectArrayParserBuilder.class).build(ObjectArrayParserBuilderFactory.class));
        this.bind(Logger.class).toInstance((Object)LoggerFactory.getLogger((String)"unXml"));
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.bind(ObjectMapper.class).annotatedWith((Annotation)Names.named((String)"json-mapper")).toInstance((Object)mapper);
        this.bind(NamespaceContext.class).toInstance((Object)new SimpleNamespaceContext(this.namespaces));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.bind(DocumentBuilderFactory.class).toInstance((Object)documentBuilderFactory);
        this.bind(ErrorHandler.class).to(LoggingErrorHandler.class);
        this.bind(Parsing.class);
        this.expose(Parsing.class);
        this.bind(XmlUtil.class);
        this.expose(XmlUtil.class);
        this.bind(SimpleParsers.class);
        this.expose(SimpleParsers.class);
    }
}

