/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.inject.assistedinject.Assisted;
import com.nerdforge.unxml.parsers.Parser;
import com.nerdforge.unxml.xml.XmlUtil;
import java.util.stream.Collector;
import javax.inject.Inject;
import org.w3c.dom.Node;

public class ArrayNodeParser
implements Parser<ArrayNode> {
    private String xpath;
    private Parser<?> parser;
    private XmlUtil xmlUtil;

    @Inject
    public ArrayNodeParser(@Assisted String xpath, @Assisted Parser<?> parser, XmlUtil xmlUtil) {
        this.xpath = xpath;
        this.parser = parser;
        this.xmlUtil = xmlUtil;
    }

    @Override
    public ArrayNode apply(Node node) {
        return this.xmlUtil.parseNodes(this.xpath, node).stream().map(this.parser).collect(this.toArrayNode());
    }

    private Collector<JsonNode, ArrayNode, ArrayNode> toArrayNode() {
        return Collector.of(() -> ((JsonNodeFactory)JsonNodeFactory.instance).arrayNode(), ArrayNode::add, ArrayNode::addAll, new Collector.Characteristics[0]);
    }
}

