/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.parsers.builders;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.nerdforge.unxml.factory.ObjectNodeParserFactory;
import com.nerdforge.unxml.json.JsonUtil;
import com.nerdforge.unxml.parsers.ObjectParser;
import com.nerdforge.unxml.parsers.Parser;
import com.nerdforge.unxml.parsers.SimpleParsers;
import com.nerdforge.unxml.parsers.builders.ParserBuilder;
import java.util.Map;
import java.util.Optional;

public class ObjectNodeParserBuilder
implements ParserBuilder<ObjectNode> {
    private Map<String, Parser<?>> attributes = Maps.newHashMap();
    private Optional<String> xpath = Optional.empty();
    private SimpleParsers simpleParsers;
    private ObjectNodeParserFactory factory;
    private JsonUtil jsonUtil;

    @Inject
    public ObjectNodeParserBuilder(SimpleParsers simpleParsers, ObjectNodeParserFactory factory, JsonUtil jsonUtil) {
        this.simpleParsers = simpleParsers;
        this.factory = factory;
        this.jsonUtil = jsonUtil;
    }

    public ObjectNodeParserBuilder xpath(String root) {
        this.xpath = Optional.of(root);
        return this;
    }

    public ObjectNodeParserBuilder attribute(String xpath) {
        return this.attribute(xpath, xpath, this.simpleParsers.textParser());
    }

    public ObjectNodeParserBuilder attribute(String key, String xpath) {
        return this.attribute(key, xpath, this.simpleParsers.textParser());
    }

    public ObjectNodeParserBuilder attribute(String key, Parser<?> parser) {
        this.attributes.put(key, parser);
        return this;
    }

    public ObjectNodeParserBuilder attribute(String key, ParserBuilder builder) {
        return this.attribute(key, builder.build());
    }

    public ObjectNodeParserBuilder attribute(String key, String xpath, ParserBuilder builder) {
        return this.attribute(key, xpath, builder.build());
    }

    public ObjectNodeParserBuilder attribute(String key, String xpath, Parser<?> parser) {
        Parser<JsonNode> elementParser = this.simpleParsers.elementParser(xpath, parser);
        return this.attribute(key, elementParser::apply);
    }

    @Override
    public Parser<ObjectNode> build() {
        return this.factory.create(this.xpath.map(this::wrapAttributes).orElse(this.attributes));
    }

    public <A> ObjectParser<A> as(Class<A> valueType) {
        return this.build().andThen(this.jsonUtil.as(valueType))::apply;
    }

    private Map<String, Parser<?>> wrapAttributes(String path) {
        return Maps.transformValues(this.attributes, parser -> this.simpleParsers.elementParser(path, (Parser<?>)parser));
    }
}

