/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;

public class JsonUtil {
    private ObjectMapper mapper;

    @Inject
    public JsonUtil(@Named(value="json-mapper") ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public <A> Function<ObjectNode, A> as(Class<A> valueType) {
        return node -> this.treeToValue((TreeNode)node, valueType);
    }

    public <A> Function<ArrayNode, List<A>> asList(Class<A> valueType) {
        return node -> this.readValue(node.traverse(), this.listType(valueType));
    }

    private <A> List<A> readValue(JsonParser jsonParser, CollectionType type) {
        try {
            return (List)this.mapper.readValue(jsonParser, (JavaType)type);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T> T treeToValue(TreeNode n, Class<T> valueType) {
        try {
            return (T)this.mapper.treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private <A> CollectionType listType(Class<A> valueType) {
        return TypeFactory.defaultInstance().constructCollectionType(List.class, valueType);
    }
}

