/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.nerdforge.unxml.parsers.Parser;
import com.nerdforge.unxml.xml.XmlUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Node;

@Singleton
public class SimpleParsers {
    private ObjectMapper mapper;
    private XmlUtil xmlUtil;

    @Inject
    public SimpleParsers(@Named(value="json-mapper") ObjectMapper mapper, XmlUtil xmlUtil) {
        this.mapper = mapper;
        this.xmlUtil = xmlUtil;
    }

    public Parser<JsonNode> dateParser() {
        return node -> this.mapper.valueToTree((Object)LocalDate.parse(node.getTextContent()).toString());
    }

    public Parser<JsonNode> dateParser(DateTimeFormatter formatter) {
        return this.textParser(value -> LocalDate.parse(value, formatter));
    }

    public Parser<JsonNode> numberParser() {
        return this.textParser(Double::parseDouble);
    }

    public Parser<JsonNode> nodeNameParser() {
        return node -> this.mapper.valueToTree((Object)node.getNodeName());
    }

    public Parser<JsonNode> textParser() {
        return node -> this.mapper.valueToTree((Object)node.getTextContent());
    }

    public Parser<JsonNode> textParser(Function<String, Object> transformer) {
        return node -> this.mapper.valueToTree(transformer.apply(node.getTextContent()));
    }

    public Parser<JsonNode> elementParser(String xpath, Parser<?> parser) {
        return node -> (JsonNode)this.xmlUtil.parseNode(xpath, (Node)node).map(parser).orElse(NullNode.getInstance());
    }
}

