/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.parsers.builders;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.nerdforge.unxml.factory.ArrayNodeParserFactory;
import com.nerdforge.unxml.json.JsonUtil;
import com.nerdforge.unxml.parsers.ObjectParser;
import com.nerdforge.unxml.parsers.Parser;
import com.nerdforge.unxml.parsers.builders.ParserBuilder;
import java.util.List;

public class ArrayNodeParserBuilder
implements ParserBuilder<ArrayNode> {
    private final String xpath;
    private final Parser<?> parser;
    private final ArrayNodeParserFactory arrayNodeParserFactory;
    private final JsonUtil jsonUtil;

    @Inject
    public ArrayNodeParserBuilder(@Assisted String xpath, @Assisted Parser<?> parser, ArrayNodeParserFactory arrayNodeParserFactory, JsonUtil jsonUtil) {
        this.xpath = xpath;
        this.parser = parser;
        this.arrayNodeParserFactory = arrayNodeParserFactory;
        this.jsonUtil = jsonUtil;
    }

    @Override
    public Parser<ArrayNode> build() {
        return this.arrayNodeParserFactory.create(this.xpath, this.parser);
    }

    public <A> ObjectParser<List<A>> as(Class<A> valueType) {
        return this.build().andThen(this.jsonUtil.asList(valueType))::apply;
    }
}

