/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.parsers.builders;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.nerdforge.unxml.factory.ArrayNodeParserBuilderFactory;
import com.nerdforge.unxml.parsers.ObjectParser;
import com.nerdforge.unxml.parsers.Parser;
import com.nerdforge.unxml.parsers.builders.ObjectNodeParserBuilder;
import com.nerdforge.unxml.parsers.builders.ParserBuilder;
import java.util.List;

public class ObjectArrayParserBuilder
implements ParserBuilder<ArrayNode> {
    private final String xpath;
    private ArrayNodeParserBuilderFactory factory;
    private ObjectNodeParserBuilder builder;

    @Inject
    public ObjectArrayParserBuilder(@Assisted String xpath, ArrayNodeParserBuilderFactory factory, ObjectNodeParserBuilder builder) {
        this.xpath = xpath;
        this.factory = factory;
        this.builder = builder;
    }

    public ObjectArrayParserBuilder attribute(String xpath) {
        this.builder.attribute(xpath);
        return this;
    }

    public ObjectArrayParserBuilder attribute(String key, String xpath) {
        this.builder.attribute(key, xpath);
        return this;
    }

    public ObjectArrayParserBuilder attribute(String key, Parser<?> parser) {
        this.builder.attribute(key, parser);
        return this;
    }

    public ObjectArrayParserBuilder attribute(String key, ParserBuilder builder) {
        this.builder.attribute(key, builder);
        return this;
    }

    public ObjectArrayParserBuilder attribute(String key, String xpath, ParserBuilder builder) {
        this.builder.attribute(key, xpath, builder);
        return this;
    }

    public ObjectArrayParserBuilder attribute(String key, String xpath, Parser<?> parser) {
        this.builder.attribute(key, xpath, parser);
        return this;
    }

    @Override
    public Parser<ArrayNode> build() {
        return this.factory.create(this.xpath, this.builder.build()).build();
    }

    public <A> ObjectParser<List<A>> as(Class<A> valueType) {
        return this.factory.create(this.xpath, this.builder.build()).as(valueType);
    }
}

