/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.xml;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public final class SimpleNamespaceContext
implements NamespaceContext {
    private final Map<String, String> namespaces;
    private final Multimap<String, String> prefixes;

    public SimpleNamespaceContext(Map<String, String> namespaces) {
        this.namespaces = this.addConstants(namespaces);
        this.prefixes = Multimaps.invertFrom((Multimap)Multimaps.forMap(this.namespaces), (Multimap)ArrayListMultimap.create());
    }

    @Override
    public String getNamespaceURI(String prefix) {
        this.checkNotNull(prefix);
        return this.namespaces.getOrDefault(prefix, "");
    }

    @Override
    public String getPrefix(String namespaceURI) {
        this.checkNotNull(namespaceURI);
        return this.prefixes.get((Object)namespaceURI).stream().findFirst().orElse(null);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        this.checkNotNull(namespaceURI);
        return this.prefixes.get((Object)namespaceURI).iterator();
    }

    private String checkNotNull(String reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    private Map<String, String> addConstants(Map<String, String> map) {
        HashMap namespaces = Maps.newHashMap(map);
        namespaces.putIfAbsent("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces.putIfAbsent("xmlns", "http://www.w3.org/2000/xmlns/");
        return Collections.unmodifiableMap(namespaces);
    }
}

