/*
 * Decompiled with CFR 0.152.
 */
package com.nerdforge.unxml.xml;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Singleton
public class XmlUtil {
    private final Logger logger;
    private final DocumentBuilderFactory factory;
    private final ErrorHandler errorHandler;
    private final NamespaceContext namespaceContext;
    private XPathFactory xpathFactory = XPathFactory.newInstance();

    @Inject
    public XmlUtil(Logger logger, DocumentBuilderFactory factory, ErrorHandler errorHandler, NamespaceContext namespaceContext) {
        this.logger = logger;
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.namespaceContext = namespaceContext;
    }

    public Document document(File file) {
        Preconditions.checkNotNull((Object)file);
        return this.document(file.toURI());
    }

    public Document document(URI uri) {
        Preconditions.checkNotNull((Object)uri);
        return this.document(new InputSource(uri.toASCIIString()));
    }

    public Document document(String str) {
        Preconditions.checkNotNull((Object)str);
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes(Charsets.UTF_8));
        return this.document(new InputSource(input));
    }

    public Document document(InputSource source) {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            return builder.parse(source);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Optional<Node> parseNode(String xpath, Node node) {
        return Optional.ofNullable((Node)this.evaluate(xpath, node, XPathConstants.NODE));
    }

    public List<Node> parseNodes(String xpath, Node node) {
        return this.normalizeNodeList((NodeList)this.evaluate(xpath, node, XPathConstants.NODESET));
    }

    private Object evaluate(String path, Node node, QName returnType) {
        try {
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            this.logger.debug("Evaluating XML with: xpath=[{}], node=[{}], returnType=[{}]", new Object[]{path, node.getNodeName(), returnType.getLocalPart()});
            Object result = xpath.evaluate(path, node, returnType);
            return this.logWarnIfNull(result, path, node.getNodeName());
        }
        catch (XPathExpressionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Object logWarnIfNull(Object obj, String path, String nodeName) {
        if (obj == null) {
            this.logger.warn("No node found at xpath=[{}], nodeName=[{}]", (Object)path, (Object)nodeName);
        }
        return obj;
    }

    private List<Node> normalizeNodeList(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).collect(Collectors.toList());
    }
}

