/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.connector.jndi.directory;

import com.identity4j.connector.AbstractConnectorConfiguration;
import com.identity4j.connector.exception.ConnectorException;
import com.identity4j.connector.util.DummySSLSocketFactory;
import com.identity4j.util.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDirectoryConfiguration
extends AbstractConnectorConfiguration {
    static Log LOG = LogFactory.getLog(AbstractDirectoryConfiguration.class);
    public static final String DIRECTORY_HOSTNAME = "directory.hostname";
    public static final String DIRECTORY_BACKUP_HOSTNAMES = "directory.backupHostnames";
    public static final String DIRECTORY_BASE_DN = "directory.baseDn";
    public static final String DIRECTORY_USER_OU = "directory.userOU";
    public static final String DIRECTORY_SERVICE_ACCOUNT_USERNAME = "directory.serviceAccountUsername";
    public static final String DIRECTORY_SERVICE_ACCOUNT_PASSWORD = "directory.serviceAccountPassword";
    public static final String DIRECTORY_DOMAIN = "directory.domain";
    public static final String DIRECTORY_SECURITY_PROTOCOL = "directory.protocol";
    public static final String DIRECTORY_EXCLUDES = "directory.excludes";
    public static final String DIRECTORY_INCLUDES = "directory.includes";
    public static final String DIRECTORY_ROLE_MODE = "directory.roleMode";
    public static final String DIRECTORY_INCLUDE_ROLES = "directory.includeRoles";
    public static final String DIRECTORY_EXCLUDE_ROLES = "directory.excludeRoles";
    public static final String DIRECTORY_INCLUDE_ROLES_DN = "directory.includeRolesDN";
    public static final String DIRECTORY_EXCLUDE_ROLES_DN = "directory.excludeRolesDN";
    public static final String DIRECTORY_FOLLOW_REFERRALS = "directory.followReferrals";
    public static final String DIRECTORY_CONNECT_TIMEOUT = "directory.timeout";
    public static final String DIRECTORY_READ_TIMEOUT = "directory.readTimeout";
    public static final String DIRECTORY_MAX_PAGE_SIZE = "directory.maxPageSize";
    public static final char PORT_SEPARATOR = ':';
    public static final String COMMON_NAME = "CN=";
    public static final String SSL = "ssl";
    public static final String PLAIN = "plain";
    public static final String LDAP_PROTOCOL = "ldap://";
    public static final String LDAPS_PROTOCOL = "ldaps://";
    private final Name baseDn;
    private final Collection<Name> includes;
    private final Collection<Name> excludes;
    private final Set<String> includeRoles;
    private final Set<String> excludeRoles;
    private final Set<String> includeRolesDN;
    private final Set<String> excludeRolesDN;
    private RoleMode roleMode;
    String securityProtocol = "ssl";

    public AbstractDirectoryConfiguration(MultiMap configurationParameters) {
        super(configurationParameters);
        try {
            this.baseDn = new LdapName(configurationParameters.getStringOrDefault(DIRECTORY_BASE_DN, ""));
            this.includes = this.getNames(configurationParameters.getStringArrayOrDefault(DIRECTORY_INCLUDES, new String[0]));
            this.excludes = this.getNames(configurationParameters.getStringArrayOrDefault(DIRECTORY_EXCLUDES, new String[0]));
            this.includes.removeAll(this.excludes);
            this.securityProtocol = configurationParameters.getStringOrDefault(DIRECTORY_SECURITY_PROTOCOL, SSL);
            try {
                this.roleMode = RoleMode.valueOf(configurationParameters.getStringOrDefault(DIRECTORY_ROLE_MODE, RoleMode.principalNames.name()));
            }
            catch (IllegalStateException ise) {
                LOG.warn((Object)String.format("Invalid role mode, reverting to %s", new Object[]{RoleMode.principalNames}));
                this.roleMode = RoleMode.principalNames;
            }
            this.includeRoles = new HashSet<String>(Arrays.asList(configurationParameters.getStringArrayOrDefault(DIRECTORY_INCLUDE_ROLES, new String[0])));
            this.excludeRoles = new HashSet<String>(Arrays.asList(configurationParameters.getStringArrayOrDefault(DIRECTORY_EXCLUDE_ROLES, new String[0])));
            this.includeRolesDN = new HashSet<String>(Arrays.asList(configurationParameters.getStringArrayOrDefault(DIRECTORY_INCLUDE_ROLES_DN, new String[0])));
            this.excludeRolesDN = new HashSet<String>(Arrays.asList(configurationParameters.getStringArrayOrDefault(DIRECTORY_EXCLUDE_ROLES_DN, new String[0])));
            if (this.includes.isEmpty()) {
                this.includes.add(this.baseDn);
            }
        }
        catch (NamingException ne) {
            throw new Error(ne);
        }
    }

    public final String[] getControllerHosts() {
        String[] tmp;
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(this.configurationParameters.getStringArrayOrFail(DIRECTORY_HOSTNAME)));
        for (String t : tmp = this.configurationParameters.getStringArrayOrFail(DIRECTORY_BACKUP_HOSTNAMES)) {
            if (!StringUtils.isNotBlank((CharSequence)t)) continue;
            l.add(t);
        }
        return l.toArray(new String[0]);
    }

    public final String[] getControllerHostnames() {
        ArrayList<String> l = new ArrayList<String>();
        for (String h : this.getControllerHosts()) {
            l.add(AbstractDirectoryConfiguration.getControllerHostWithoutPort(h));
        }
        return l.toArray(new String[0]);
    }

    public Collection<Name> getIncludes() {
        return this.includes;
    }

    public Collection<Name> getExcludes() {
        return this.excludes;
    }

    public Set<String> getIncludedRolesDN() {
        return this.includeRolesDN;
    }

    public Set<String> getExcludedRolesDN() {
        return this.excludeRolesDN;
    }

    public Set<String> getIncludedRoles() {
        return this.includeRoles;
    }

    public Set<String> getExcludedRoles() {
        return this.excludeRoles;
    }

    public boolean isEnableRoles() {
        return !this.roleMode.equals((Object)RoleMode.disabled);
    }

    public RoleMode getRoleMode() {
        return this.roleMode;
    }

    protected String[] buildProviderUrls(String ... controllerHosts) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (String controllerHost : controllerHosts) {
            hosts.add(controllerHost);
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    protected static final String getControllerHostWithoutPort(String value) {
        int indexOf = value.lastIndexOf(58);
        return indexOf == -1 ? value : value.substring(0, indexOf);
    }

    public final String getServiceAuthenticationType() {
        return this.configurationParameters.getStringOrDefault("directory.serviceAuthenticationType", "simple");
    }

    public final boolean requiresServiceAuthentication() {
        return !"none".equals(this.getServiceAuthenticationType());
    }

    public final String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public final boolean isFollowReferrals() {
        return this.configurationParameters.getBooleanOrDefault(DIRECTORY_FOLLOW_REFERRALS, Boolean.FALSE.booleanValue());
    }

    public final String getInitialContextFactory() {
        return this.configurationParameters.getStringOrDefault("directory.initialContextFactory", "com.sun.jndi.ldap.LdapCtxFactory");
    }

    public final int getTimeout() {
        return this.configurationParameters.getIntegerOrDefault(DIRECTORY_CONNECT_TIMEOUT, Integer.valueOf(30)) * 1000;
    }

    public int getMaxPageSize() {
        return this.configurationParameters.getIntegerOrDefault(DIRECTORY_MAX_PAGE_SIZE, Integer.valueOf(1000));
    }

    public final String getVersion() {
        return this.configurationParameters.getStringOrDefault("directory.version", "3");
    }

    public final Name getBaseDn() {
        return this.baseDn;
    }

    private Collection<Name> getNames(String ... values) {
        ArrayList<Name> names = new ArrayList<Name>();
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            try {
                LdapName name = new LdapName(value);
                if (!name.startsWith(this.getBaseDn())) {
                    name.addAll(0, this.getBaseDn());
                }
                names.add(name);
            }
            catch (Exception e) {
                throw new ConnectorException(String.format("%s is not a properly formatted DN. Expected format <container>=<name> for example OU=Employees", value));
            }
        }
        return names;
    }

    public final String getServiceAccountDn() {
        return this.configurationParameters.getStringOrFail(DIRECTORY_SERVICE_ACCOUNT_USERNAME);
    }

    public final String getServiceAccountPassword() {
        return this.configurationParameters.getStringOrFail(DIRECTORY_SERVICE_ACCOUNT_PASSWORD);
    }

    public final String getIdentityObjectClass() {
        return this.configurationParameters.getStringOrFail("directory.identityObjectClass");
    }

    public final List<String> getIdentityCreationObjectClasses() {
        if (this.configurationParameters.containsKey((Object)"direcctory.identityCreationObjectClasses")) {
            return Arrays.asList(this.configurationParameters.getStringOrFail("directory.identityObjectClass").split(","));
        }
        LinkedHashSet<String> n = new LinkedHashSet<String>();
        n.add("inetOrgPerson");
        n.add(this.getIdentityObjectClass());
        return new ArrayList<String>(n);
    }

    public final String getIdentityNameAttribute() {
        return this.configurationParameters.getStringOrFail("directory.identityNameAttribute");
    }

    public final String getIdentityGuidAttribute() {
        return this.configurationParameters.getStringOrFail("directory.identityGuidAttribute");
    }

    public final String getIdentityRoleGuidAttribute() {
        return this.configurationParameters.getStringOrNull("directory.identityRoleGuidAttribute");
    }

    public final String getIdentityRoleNameAttribute() {
        return this.configurationParameters.getStringOrNull("directory.identityRoleNameAttribute");
    }

    public final String getIdentityPasswordAttribute() {
        return this.configurationParameters.getStringOrFail("directory.identityPasswordAttribute");
    }

    public final String getDistinguishedNameAttribute() {
        return this.configurationParameters.getStringOrDefault("directory.distinguishedNameAttribute", "dn");
    }

    public final String getIdentityPasswordEncoding() {
        return this.configurationParameters.getStringOrFail("directory.identityPasswordEncoding");
    }

    public final String getRoleObjectClass() {
        return this.configurationParameters.getStringOrFail("directory.roleObjectClass");
    }

    public final String getRoleNameAttribute() {
        return this.configurationParameters.getStringOrFail("directory.roleNameAttribute");
    }

    public final String getRoleGuidAttribute() {
        return this.configurationParameters.getStringOrFail("directory.roleGuidAttribute");
    }

    public final Map<String, String> getConnectorConfigurationParameters() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("java.naming.factory.initial", this.getInitialContextFactory());
        ArrayList<String> filteredControllerHosts = new ArrayList<String>();
        int hostCount = 0;
        block4: for (String controllerHost : this.getControllerHosts()) {
            ++hostCount;
            int idx = controllerHost.indexOf(58);
            if (idx <= -1) continue;
            int port = Integer.parseInt(controllerHost.substring(idx + 1));
            switch (port) {
                case 389: 
                case 3268: {
                    if (hostCount > 1 && this.securityProtocol.equals(SSL)) {
                        if (!LOG.isWarnEnabled()) continue block4;
                        LOG.warn((Object)"Multiple controller hosts with different protocols [PLAIN,SSL] are not allowed");
                        continue block4;
                    }
                    if (LOG.isWarnEnabled() && this.securityProtocol.equals(SSL)) {
                        LOG.warn((Object)"Switching to PLAIN security protocol");
                    }
                    this.securityProtocol = PLAIN;
                    filteredControllerHosts.add(controllerHost);
                    continue block4;
                }
                case 636: 
                case 3269: {
                    if (this.securityProtocol.equals(PLAIN)) {
                        if (!LOG.isWarnEnabled()) continue block4;
                        LOG.warn((Object)"Multiple controller hosts with different protocols [PLAIN,SSL] are not allowed");
                        continue block4;
                    }
                    this.securityProtocol = SSL;
                    filteredControllerHosts.add(controllerHost);
                    continue block4;
                }
                default: {
                    filteredControllerHosts.add(controllerHost);
                }
            }
        }
        this.configurationParameters.set(DIRECTORY_SECURITY_PROTOCOL, new String[]{this.securityProtocol});
        variables.put("java.naming.provider.url", this.buildProviderUrl(this.getSecurityProtocol().equalsIgnoreCase(SSL), filteredControllerHosts.toArray(new String[0])));
        variables.put("java.naming.security.protocol", this.securityProtocol);
        variables.put("java.naming.security.authentication", this.getServiceAuthenticationType());
        if (SSL.equals(this.getSecurityProtocol())) {
            variables.put("java.naming.ldap.factory.socket", DummySSLSocketFactory.class.getName());
        }
        if (this.isFollowReferrals()) {
            variables.put("java.naming.referral", "follow");
        }
        variables.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.getTimeout()));
        variables.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.getReadTimeout()));
        variables.put("java.naming.ldap.version", this.getVersion());
        variables.put("com.sun.jndi.ldap.connect.pool", "true");
        variables.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
        variables.putAll(this.getInitialConfigurationParameters());
        return variables;
    }

    public String[] getProviderURLList() {
        ArrayList<String> l = new ArrayList<String>();
        boolean ssl = this.getSecurityProtocol().equalsIgnoreCase(SSL);
        for (String host : this.getControllerHosts()) {
            l.add(this.buildProviderUrl(ssl, host));
        }
        return l.toArray(new String[0]);
    }

    public String buildProviderUrl(boolean ssl, String ... controllerHosts) {
        StringBuilder builder = new StringBuilder();
        for (String controllerHost : this.buildProviderUrls(controllerHosts)) {
            int idx = controllerHost.indexOf(58);
            if (idx > -1) {
                int port = Integer.parseInt(controllerHost.substring(idx + 1));
                controllerHost = controllerHost.substring(0, idx);
                switch (port) {
                    case 389: 
                    case 3268: {
                        builder.append(LDAP_PROTOCOL).append(controllerHost).append(":").append(port);
                        break;
                    }
                    case 636: 
                    case 3269: {
                        builder.append(LDAPS_PROTOCOL).append(controllerHost).append(":").append(port);
                        break;
                    }
                    default: {
                        builder.append(ssl ? LDAPS_PROTOCOL : LDAP_PROTOCOL).append(controllerHost).append(":").append(port);
                        break;
                    }
                }
                continue;
            }
            builder.append(ssl ? LDAPS_PROTOCOL : LDAP_PROTOCOL).append(controllerHost).append(":").append(ssl ? 636 : 389);
        }
        return builder.toString().trim();
    }

    protected Map<String, String> getInitialConfigurationParameters() {
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("[ControllerHost='" + this.getControllerHosts());
        buffer.append("', ServiceAuthenticationType='" + this.getServiceAuthenticationType());
        buffer.append("', SecurityProtocol='" + this.getSecurityProtocol());
        buffer.append("', InitialContextFactory='" + this.getInitialContextFactory());
        buffer.append("', ConnectTimeout='" + this.getTimeout());
        buffer.append("', ReadTimeout='" + this.getReadTimeout());
        buffer.append("', Version='" + this.getVersion());
        buffer.append("', BaseDn='" + this.getBaseDn());
        buffer.append("', ServiceAccountUsername='" + this.getServiceAccountDn());
        buffer.append("', ServiceAccountPassword='********");
        buffer.append("', IdentityObjectClass='" + this.getIdentityObjectClass());
        buffer.append("', IdentityNameAttribute='" + this.getIdentityNameAttribute());
        buffer.append("', IdentityGuidAttribute='" + this.getIdentityGuidAttribute());
        buffer.append("', IdentityPasswordAttribute='" + this.getIdentityPasswordAttribute());
        buffer.append("', IdentityPasswordEncoding='" + this.getIdentityPasswordEncoding());
        buffer.append("', RoleObjectClass='" + this.getRoleObjectClass());
        buffer.append("', RoleNameAttribute='" + this.getRoleNameAttribute());
        buffer.append("', RoleGuidAttribute='" + this.getRoleGuidAttribute()).append("']");
        return buffer.toString();
    }

    public String getUsernameHint() {
        return this.getServiceAccountDn();
    }

    public String getHostnameHint() {
        return this.configurationParameters.getStringOrNull(DIRECTORY_HOSTNAME);
    }

    public int getReadTimeout() {
        return this.configurationParameters.getIntegerOrDefault(DIRECTORY_READ_TIMEOUT, Integer.valueOf(120000));
    }

    public String getOU() {
        return this.configurationParameters.getString(DIRECTORY_USER_OU);
    }

    public boolean isFilteredByRolePrincipalName() {
        return this.getRoleMode().equals((Object)RoleMode.principalNames) && (!this.getIncludedRoles().isEmpty() || !this.getExcludedRoles().isEmpty());
    }

    public boolean isFilteredByRoleDistinguishedName() {
        return !(!this.getRoleMode().equals((Object)RoleMode.distinguishedNames) && !this.getRoleMode().equals((Object)RoleMode.serverDistinguishedNames) || this.getIncludedRolesDN().isEmpty() && this.getExcludedRolesDN().isEmpty());
    }

    public boolean isFilteredByRole() {
        return this.isEnableRoles() && (this.isFilteredByRoleDistinguishedName() || this.isFilteredByRolePrincipalName());
    }

    public static enum RoleMode {
        disabled,
        principalNames,
        distinguishedNames,
        serverDistinguishedNames;

    }
}

