/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.connector.jndi.directory;

import com.identity4j.connector.AbstractConnector;
import com.identity4j.connector.BrowseNode;
import com.identity4j.connector.BrowseableConnector;
import com.identity4j.connector.Connector;
import com.identity4j.connector.ConnectorCapability;
import com.identity4j.connector.Media;
import com.identity4j.connector.PasswordCreationCallback;
import com.identity4j.connector.exception.ConnectorException;
import com.identity4j.connector.exception.InvalidLoginCredentialsException;
import com.identity4j.connector.exception.PrincipalNotFoundException;
import com.identity4j.connector.jndi.directory.AbstractDirectoryConfiguration;
import com.identity4j.connector.jndi.directory.DirectoryConfiguration;
import com.identity4j.connector.jndi.directory.DirectoryExceptionParser;
import com.identity4j.connector.jndi.directory.DirectoryIdentity;
import com.identity4j.connector.jndi.directory.DirectoryOU;
import com.identity4j.connector.jndi.directory.DirectoryRole;
import com.identity4j.connector.jndi.directory.LdapService;
import com.identity4j.connector.jndi.directory.filter.Eq;
import com.identity4j.connector.jndi.directory.filter.Filter;
import com.identity4j.connector.principal.Identity;
import com.identity4j.connector.principal.Principal;
import com.identity4j.connector.principal.Role;
import com.identity4j.util.CollectionUtil;
import com.identity4j.util.StringUtil;
import com.identity4j.util.Util;
import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.DefaultEncoderManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.net.SocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractDirectoryConnector<P extends AbstractDirectoryConfiguration>
extends AbstractConnector<P>
implements BrowseableConnector<P> {
    protected static final Iterator<Identity> IDENTITY_ITERATOR = CollectionUtil.emptyIterator(Identity.class);
    protected static final Iterator<Role> ROLE_ITERATOR = CollectionUtil.emptyIterator(Role.class);
    static final Log LOG = LogFactory.getLog(AbstractDirectoryConnector.class);
    public static final String WILDCARD_SEARCH = "*";
    public static final String OBJECT_CLASS_ATTRIBUTE = "objectClass";
    public static final String OU_ATTRIBUTE = "ou";
    public static final String COMMON_NAME_ATTRIBUTE = "cn";
    private static Collection<String> RESERVED_ATTRIBUTES_FOR_CREATION = Arrays.asList("ou", "objectClass", "cn");
    private static Collection<String> CORE_IDENTITY_ATTRIBUTES = Arrays.asList("cn", "objectClass");
    protected LdapService ldapService;
    protected SocketFactory socketFactory;
    protected static Set<ConnectorCapability> capabilities = new HashSet<ConnectorCapability>(Arrays.asList(ConnectorCapability.passwordChange, ConnectorCapability.passwordSet, ConnectorCapability.createUser, ConnectorCapability.deleteUser, ConnectorCapability.updateUser, ConnectorCapability.roles, ConnectorCapability.authentication, ConnectorCapability.identities, ConnectorCapability.roleAttributes, ConnectorCapability.identityAttributes));

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        if (this.ldapService != null) {
            this.ldapService.setSocketFactory(socketFactory);
        }
    }

    public void deleteIdentity(String principalName) throws ConnectorException {
        try {
            Identity identity = this.getIdentityByName(principalName);
            String identityOU = identity.getAttribute(((AbstractDirectoryConfiguration)this.getConfiguration()).getDistinguishedNameAttribute());
            this.ldapService.unbind(new LdapName(identityOU));
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteRole(String roleName) throws ConnectorException {
        try {
            Role role = this.getRoleByName(roleName);
            String roleOU = role.getAttribute(((AbstractDirectoryConfiguration)this.getConfiguration()).getDistinguishedNameAttribute());
            this.ldapService.unbind(new LdapName(roleOU));
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public Set<ConnectorCapability> getCapabilities() {
        return capabilities;
    }

    public boolean isOpen() {
        return this.ldapService != null;
    }

    protected void onClose() {
        this.ldapService.close();
        this.ldapService = null;
    }

    public boolean isReadOnly() {
        return ((AbstractDirectoryConfiguration)this.getConfiguration()).getSecurityProtocol().equals("plain");
    }

    protected Name getRootDn() {
        Name baseDn = ((AbstractDirectoryConfiguration)this.getConfiguration()).getBaseDn();
        for (int i = 0; i < baseDn.size(); ++i) {
            if (baseDn.get(i).toLowerCase().startsWith("dc=")) continue;
            Name suffix = baseDn.getPrefix(i);
            return suffix;
        }
        return (Name)baseDn.clone();
    }

    public final Identity createIdentity(Identity identity, final char[] password) throws ConnectorException {
        return this.createIdentity(identity, new PasswordCreationCallback(){

            public char[] createPassword(Identity identity) {
                return password;
            }
        }, false);
    }

    public final Identity createIdentity(Identity identity, PasswordCreationCallback passwordCallback, boolean forceChange) throws ConnectorException {
        try {
            LdapName usersDn;
            AbstractDirectoryConfiguration config = (AbstractDirectoryConfiguration)this.getConfiguration();
            String identityOU = identity.getAttribute(OU_ATTRIBUTE);
            if (StringUtil.isNullOrEmpty((String)identityOU)) {
                usersDn = new LdapName(this.getRootDn().toString());
                if (StringUtil.isNullOrEmpty((String)config.getOU())) {
                    usersDn.add("CN=Users");
                } else {
                    usersDn.add(config.getOU().toString());
                }
            } else {
                usersDn = new LdapName(identityOU);
            }
            identity.setAttribute(OU_ATTRIBUTE, new String[]{""});
            LdapName userDn = new LdapName(usersDn.toString());
            String principalName = identity.getPrincipalName();
            if (StringUtils.isNotBlank((CharSequence)identity.getFullName())) {
                userDn.add("CN=" + identity.getFullName());
                identity.setFullName(identity.getFullName());
                identity.setAttribute(COMMON_NAME_ATTRIBUTE, new String[]{identity.getFullName()});
            } else if (StringUtils.isNotBlank((CharSequence)identity.getAttribute("givenName")) || StringUtils.isNotBlank((CharSequence)identity.getAttribute("sn"))) {
                StringBuilder tmp = new StringBuilder();
                tmp.append(identity.getAttribute("givenName"));
                String initials = identity.getAttribute("initials");
                if (StringUtils.isNotBlank((CharSequence)initials)) {
                    tmp.append(" ");
                    tmp.append(initials);
                    tmp.append(".");
                }
                tmp.append(" ");
                tmp.append(identity.getAttribute("sn"));
                userDn.add("CN=" + tmp.toString());
                identity.setFullName(tmp.toString());
                identity.setAttribute(COMMON_NAME_ATTRIBUTE, new String[]{tmp.toString()});
            } else {
                userDn.add("CN=" + identity.getPrincipalName());
                identity.setFullName(identity.getPrincipalName());
                identity.setAttribute(COMMON_NAME_ATTRIBUTE, new String[]{identity.getPrincipalName()});
            }
            Name baseDn = ((AbstractDirectoryConfiguration)this.getConfiguration()).getBaseDn();
            if (!userDn.toString().toLowerCase().endsWith(baseDn.toString().toLowerCase())) {
                throw new ConnectorException("The User DN (" + userDn + ") must be a child of the Base DN (" + baseDn + " configured for the Active Directory connector.");
            }
            boolean included = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludes().isEmpty();
            if (!included) {
                for (Name name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludes()) {
                    if (!userDn.startsWith(name)) continue;
                    included = true;
                }
            }
            if (included) {
                for (Name name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getExcludes()) {
                    if (!userDn.startsWith(name)) continue;
                    included = false;
                }
            }
            if (!included) {
                throw new ConnectorException("The User DN (" + userDn + ") must be within the included OU scopes configured for the Active Directory connector.");
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (Map.Entry entry : identity.getAttributes().entrySet()) {
                String[] stringArray;
                if (this.getCoreIdentityAttributes().contains(entry.getKey()) || ((String)entry.getKey()).equals(this.getEmailAttribute()) || ((String)entry.getKey()).equals(this.getMobileAttribute()) || (stringArray = (String[])entry.getValue()).length <= 0 || StringUtils.isEmpty((CharSequence)stringArray[0])) continue;
                if (stringArray.length == 1) {
                    attributes.add(new BasicAttribute((String)entry.getKey(), stringArray[0]));
                    continue;
                }
                BasicAttribute attr = new BasicAttribute((String)entry.getKey());
                for (String val : stringArray) {
                    LOG.info((Object)("Setting " + (String)entry.getKey() + " = " + val));
                    attr.add(val);
                }
                attributes.add(attr);
            }
            if (StringUtils.isNotBlank((CharSequence)identity.getAddress(Media.email))) {
                attributes.add(new BasicAttribute(this.getEmailAttribute(), identity.getAddress(Media.email)));
            }
            if (StringUtils.isNotBlank((CharSequence)identity.getAddress(Media.mobile))) {
                attributes.add(new BasicAttribute(this.getMobileAttribute(), identity.getAddress(Media.mobile)));
            }
            BasicAttribute basicAttribute = new BasicAttribute(OBJECT_CLASS_ATTRIBUTE);
            for (String string : this.getIdentityCreationObjectClasses(identity)) {
                basicAttribute.add(string);
            }
            attributes.add(basicAttribute);
            attributes.add(new BasicAttribute(COMMON_NAME_ATTRIBUTE, identity.getFullName()));
            String string = this.finaliseCreate(identity, principalName, attributes);
            this.ldapService.bind(userDn, attributes.toArray(new Attribute[0]));
            for (Role r : identity.getRoles()) {
                this.assignRole(userDn, r);
            }
            DirectoryIdentity directoryIdentity = (DirectoryIdentity)this.getIdentityByName(string);
            this.ldapService.setPassword(userDn.toString(), passwordCallback.createPassword((Identity)directoryIdentity));
            if (this.getCapabilities().contains(ConnectorCapability.accountDisable)) {
                this.enableIdentity((Identity)directoryIdentity);
            }
            this.finaliseCreate(directoryIdentity, forceChange);
            return directoryIdentity;
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    protected List<String> getIdentityCreationObjectClasses(Identity identity) {
        return ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityCreationObjectClasses();
    }

    protected void finaliseCreate(DirectoryIdentity directoryIdentity, boolean forceChange) {
    }

    protected String finaliseCreate(Identity identity, String principalName, List<Attribute> attributes) {
        String upn = identity.getAttribute(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityNameAttribute());
        if (StringUtils.isBlank((CharSequence)upn)) {
            upn = principalName;
        }
        attributes.add(new BasicAttribute(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityNameAttribute(), upn));
        return upn;
    }

    protected Collection<String> getCoreIdentityAttributes() {
        return CORE_IDENTITY_ATTRIBUTES;
    }

    protected void assignRole(LdapName userDn, Role role) throws NamingException, IOException {
    }

    protected String processNamingException(NamingException nme, Connector.PasswordResetType type, Principal pricipal) {
        return this.getReason(nme);
    }

    protected void checkOtherCreationExceptions(Identity identity, Exception e) {
    }

    protected void checkNamingException(String errorText, NamingException nme, Principal principal) throws ConnectorException {
        this.processNamingException(nme, null, principal);
        DirectoryExceptionParser dep = new DirectoryExceptionParser(nme);
        String reason = dep.getReason();
        LOG.error((Object)(errorText + ". Reason code give was " + reason), (Throwable)nme);
        throw new ConnectorException("Failed to perform operation. Reason code " + reason + ". Please see the logs for more detail.");
    }

    protected Collection<String> getAttributesReservedForCreation() {
        return RESERVED_ATTRIBUTES_FOR_CREATION;
    }

    protected String getEmailAttribute() {
        return "mail";
    }

    protected String getMobileAttribute() {
        return "mobile";
    }

    protected List<ModificationItem> getCreationPasswordModificationItems(char[] password, DirectoryConfiguration config) throws EncoderException {
        ArrayList<ModificationItem> items = new ArrayList<ModificationItem>();
        byte[] encodedPassword = DefaultEncoderManager.getInstance().encode(password, config.getIdentityPasswordEncoding(), "UTF-8", null, null);
        BasicAttribute attribute = new BasicAttribute(config.getIdentityPasswordAttribute(), encodedPassword);
        items.add(new ModificationItem(2, attribute));
        return items;
    }

    public boolean supportsOptimisedCheckCredentials() {
        return true;
    }

    public boolean checkCredentialsOptimised(String username, String remoteIdentifier, char[] password) throws ConnectorException {
        try {
            LOG.info((Object)"Check credentials (optimised)");
            this.ldapService.authenticate(remoteIdentifier, new String(password));
            LOG.info((Object)"Verified credentials (optimised)");
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (NamingException e) {
            this.processNamingException(e);
            return false;
        }
    }

    protected boolean areCredentialsValid(Identity identity, char[] password) throws ConnectorException {
        DirectoryIdentity directoryIdentity = (DirectoryIdentity)identity;
        try {
            this.ldapService.authenticate(directoryIdentity.getDn().toString(), new String(password));
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (NamingException e) {
            try {
                this.processNamingException(e);
            }
            catch (InvalidLoginCredentialsException invalidLoginCredentialsException) {
                // empty catch block
            }
            return false;
        }
    }

    protected void changePassword(Identity identity, char[] oldPassword, char[] password) {
        DirectoryIdentity directoryIdentity = (DirectoryIdentity)identity;
        try {
            this.ldapService.setPassword(directoryIdentity.getDn().toString(), password);
        }
        catch (NamingException e) {
            LOG.error((Object)"Problem in changing password.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Problem in changing password.", (Throwable)e);
        }
    }

    protected boolean isIncluded(String dn) throws InvalidNameException {
        return this.isIncluded(new LdapName(dn));
    }

    protected boolean isIncluded(Name dn) {
        Name baseDn = ((AbstractDirectoryConfiguration)this.getConfiguration()).getBaseDn();
        if (!dn.toString().toLowerCase().endsWith(baseDn.toString().toLowerCase())) {
            return false;
        }
        boolean included = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludes().isEmpty();
        if (!included) {
            for (Name name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludes()) {
                if (!dn.startsWith(name)) continue;
                included = true;
            }
        }
        if (included) {
            for (Name name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getExcludes()) {
                if (!dn.startsWith(name)) continue;
                included = false;
            }
        }
        return included;
    }

    public void updateIdentity(Identity identity) throws ConnectorException {
        try {
            LdapName newDN;
            ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
            Identity oldIdentity = this.getIdentityByName(identity.getPrincipalName());
            AbstractDirectoryConfiguration config = (AbstractDirectoryConfiguration)this.getConfiguration();
            String identityOU = identity.getAttribute(config.getDistinguishedNameAttribute());
            LdapName usersDn = new LdapName(identityOU);
            this.processUserAttributes(modificationItems, oldIdentity, identity);
            if (!modificationItems.isEmpty()) {
                this.ldapService.update(usersDn, modificationItems.toArray(new ModificationItem[0]));
            }
            ArrayList<Role> toRemove = new ArrayList<Role>(Arrays.asList(oldIdentity.getRoles()));
            ArrayList<Role> toAdd = new ArrayList<Role>(Arrays.asList(identity.getRoles()));
            toRemove.removeAll(Arrays.asList(identity.getRoles()));
            toAdd.removeAll(Arrays.asList(oldIdentity.getRoles()));
            for (Role r : toRemove) {
                if (!this.isIncluded(r.getAttribute(((AbstractDirectoryConfiguration)this.getConfiguration()).getDistinguishedNameAttribute()))) continue;
                this.revokeRole(usersDn, r);
            }
            for (Role r : toAdd) {
                this.assignRole(usersDn, r);
            }
            if (Util.differs((Object)oldIdentity.getFullName(), (Object)identity.getFullName())) {
                newDN = new LdapName(usersDn.getSuffix(1).toString());
                newDN.add(0, "CN=" + identity.getFullName());
                this.ldapService.rename(usersDn, newDN);
            } else if (Util.differs((Object)oldIdentity.getAttribute(COMMON_NAME_ATTRIBUTE), (Object)identity.getAttribute(COMMON_NAME_ATTRIBUTE))) {
                newDN = new LdapName(usersDn.toString());
                newDN.remove(newDN.size() - 1);
                newDN.add(newDN.size(), "CN=" + identity.getAttribute(COMMON_NAME_ATTRIBUTE));
                this.ldapService.rename(usersDn, newDN);
            } else if (Util.differs((Object)oldIdentity.getAttribute(OU_ATTRIBUTE), (Object)identity.getAttribute(OU_ATTRIBUTE))) {
                newDN = new LdapName("CN=" + identity.getAttribute(COMMON_NAME_ATTRIBUTE) + "," + identity.getAttribute(OU_ATTRIBUTE));
                this.ldapService.rename(usersDn, newDN);
            }
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isExcludeForUserUpdate(String attributeName) {
        return false;
    }

    protected void processUserAttributes(List<ModificationItem> modificationItems, Identity previousState, Identity newState) {
        for (Map.Entry entry : newState.getAttributes().entrySet()) {
            String[] newValue;
            if (this.isExcludeForUserUpdate((String)entry.getKey())) continue;
            if (!previousState.getAttributes().containsKey(entry.getKey())) {
                String[] value;
                if (((String[])entry.getValue()).length <= 0 || (value = (String[])entry.getValue()).length <= 0 || StringUtils.isEmpty((CharSequence)value[0])) continue;
                BasicAttribute attr = new BasicAttribute((String)entry.getKey());
                for (String val : value) {
                    attr.add(val);
                }
                modificationItems.add(new ModificationItem(1, attr));
                continue;
            }
            String[] oldValue = (String[])previousState.getAttributes().get(entry.getKey());
            if (Objects.deepEquals(oldValue, newValue = (String[])newState.getAttributes().get(entry.getKey()))) continue;
            String[] value = (String[])entry.getValue();
            if (value.length > 0 && !StringUtils.isEmpty((CharSequence)value[0])) {
                BasicAttribute attr = new BasicAttribute((String)entry.getKey());
                for (String val : value) {
                    attr.add(val);
                }
                modificationItems.add(new ModificationItem(2, attr));
                continue;
            }
            BasicAttribute attr = new BasicAttribute((String)entry.getKey());
            modificationItems.add(new ModificationItem(3, attr));
        }
    }

    protected void revokeRole(LdapName userDn, Role role) throws NamingException, IOException {
    }

    protected void setPassword(Identity identity, char[] password, boolean forcePasswordChangeAtLogon, Connector.PasswordResetType type) throws ConnectorException {
        DirectoryIdentity directoryIdentity = (DirectoryIdentity)identity;
        try {
            this.ldapService.setPassword(directoryIdentity.getDn().toString(), password);
        }
        catch (NamingException e) {
            LOG.error((Object)"Problem in getting identities.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Problem in getting identities.", (Throwable)e);
        }
    }

    public Iterator<DirectoryOU> getOrganizationalUnits() throws ConnectorException, IOException {
        try {
            return this.ldapService.search(this.ldapService.buildObjectClassFilter("organizationalUnit", OU_ATTRIBUTE, WILDCARD_SEARCH), new LdapService.ResultMapper<DirectoryOU>(){

                @Override
                public DirectoryOU apply(SearchResult result) throws NamingException {
                    return new DirectoryOU((String)result.getAttributes().get("distinguishedName").get(), (String)result.getAttributes().get(AbstractDirectoryConnector.OU_ATTRIBUTE).get());
                }

                @Override
                public boolean isApplyFilters() {
                    return true;
                }
            }, this.ldapService.getSearchControls());
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public final Identity getIdentityByName(String identityName) throws PrincipalNotFoundException, ConnectorException {
        Filter identityFilter = this.buildIdentityFilter(identityName);
        return (Identity)this.getPrincipal(identityFilter.encode(), this.getIdentities(identityFilter));
    }

    public final Identity getIdentityByGuid(String identityGuid) throws PrincipalNotFoundException, ConnectorException {
        Filter identityFilter = this.buildGuidFilter(identityGuid);
        return (Identity)this.getPrincipal(identityFilter.encode(), this.getIdentities(identityFilter));
    }

    public final Iterator<Identity> allIdentities() throws ConnectorException {
        return this.getIdentities(this.buildIdentityFilter(WILDCARD_SEARCH));
    }

    protected Filter buildRoleFilter(String roleName, boolean isWildcard) {
        String roleObjectClass = ((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleObjectClass();
        String roleNameAttribute = ((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleNameAttribute();
        return this.ldapService.buildObjectClassFilter(roleObjectClass, roleNameAttribute, roleName);
    }

    protected Filter buildGuidFilter(String identityGuid) {
        String identityObjectClass = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityObjectClass();
        String identityGuidAttribute = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityGuidAttribute();
        return this.ldapService.buildObjectClassFilter(identityObjectClass, identityGuidAttribute, identityGuid);
    }

    protected Filter buildIdentityFilter(String identityName) {
        String identityObjectClass = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityObjectClass();
        String identityNameAttribute = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityNameAttribute();
        return this.ldapService.buildObjectClassFilter(identityObjectClass, identityNameAttribute, identityName);
    }

    public Iterator<Identity> getIdentities(Filter filter) {
        try {
            return this.ldapService.search(filter, new LdapService.ResultMapper<Identity>(){

                @Override
                public Identity apply(SearchResult result) throws NamingException {
                    return AbstractDirectoryConnector.this.mapIdentity(result);
                }

                @Override
                public boolean isApplyFilters() {
                    return true;
                }
            }, this.configureSearchControls(this.ldapService.getSearchControls()));
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    protected Identity mapIdentity(SearchResult result) throws NamingException {
        boolean included;
        Attributes attributes = result.getAttributes();
        Attribute guidAttr = attributes.get(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityGuidAttribute());
        String guid = guidAttr == null ? "" : StringUtil.nonNull((String)guidAttr.get().toString());
        Attribute nameAttr = attributes.get(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityNameAttribute());
        String identityName = nameAttr == null ? "" : StringUtil.nonNull((String)nameAttr.get().toString());
        LdapName dn = new LdapName(result.getName().toString());
        Name base = ((AbstractDirectoryConfiguration)this.getConfiguration()).getBaseDn();
        for (int i = base.size() - 1; i >= 0; --i) {
            dn.add(0, base.get(i));
        }
        NamingEnumeration<? extends Attribute> ne = attributes.getAll();
        DirectoryIdentity directoryIdentity = new DirectoryIdentity(guid, identityName, dn);
        directoryIdentity.setAttribute("dn", dn.toString());
        while (ne.hasMoreElements()) {
            Attribute a = ne.next();
            if (a.getID().equals(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityGuidAttribute()) || a.getID().equals(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityNameAttribute())) continue;
            ArrayList<String> vals = new ArrayList<String>();
            NamingEnumeration<?> ane = a.getAll();
            while (ane.hasMoreElements()) {
                Object val = ane.next();
                vals.add(val == null ? null : String.valueOf(val));
            }
            directoryIdentity.setAttribute(a.getID(), vals.toArray(new String[0]));
        }
        String idRoleAttr = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityRoleGuidAttribute();
        Role role = null;
        if (!StringUtil.isNullOrEmpty((String)idRoleAttr)) {
            String roleObjectClass = ((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleObjectClass();
            String roleNameAttribute = ((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleGuidAttribute();
            Attribute roleAttr = attributes.get(idRoleAttr);
            if (roleAttr != null) {
                Filter filter = this.ldapService.buildObjectClassFilter(roleObjectClass, roleNameAttribute, roleAttr.get().toString());
                role = (Role)this.getPrincipal(filter.encode(), this.getRoles(filter, true));
            }
        } else {
            idRoleAttr = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityRoleNameAttribute();
            if (!StringUtil.isNullOrEmpty((String)idRoleAttr)) {
                role = this.getRoleByName(idRoleAttr);
            }
        }
        if (role != null && (included = this.isIncluded(role))) {
            directoryIdentity.addRole(role);
        }
        return directoryIdentity;
    }

    protected boolean isIncluded(Role role) {
        boolean included = true;
        if (((AbstractDirectoryConfiguration)this.getConfiguration()).isFilteredByRolePrincipalName()) {
            included = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludedRoles().isEmpty();
            if (!included) {
                for (String name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludedRoles()) {
                    if (!role.getPrincipalName().equals(name)) continue;
                    included = true;
                }
            }
            if (included) {
                for (String name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getExcludedRoles()) {
                    if (!role.getPrincipalName().equals(name)) continue;
                    included = false;
                }
            }
        }
        if (((AbstractDirectoryConfiguration)this.getConfiguration()).isFilteredByRoleDistinguishedName() && !((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleMode().equals((Object)AbstractDirectoryConfiguration.RoleMode.serverDistinguishedNames)) {
            included = ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludedRolesDN().isEmpty();
            if (!included) {
                for (String name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludedRolesDN()) {
                    if (!role.getPrincipalName().equals(name)) continue;
                    included = true;
                }
            }
            if (included) {
                for (String name : ((AbstractDirectoryConfiguration)this.getConfiguration()).getExcludedRolesDN()) {
                    if (!role.getPrincipalName().equals(name)) continue;
                    included = false;
                }
            }
        }
        return included;
    }

    public final Role getRoleByName(String roleName) throws PrincipalNotFoundException, ConnectorException {
        if (!((AbstractDirectoryConfiguration)this.getConfiguration()).isEnableRoles()) {
            throw new PrincipalNotFoundException("Roles are not enabled");
        }
        Filter roleNameFilter = this.buildRoleFilter(roleName, false);
        return (Role)this.getPrincipal(roleNameFilter.encode(), this.getRoles(roleNameFilter, true));
    }

    public final Iterator<Role> allRoles() throws ConnectorException {
        if (!((AbstractDirectoryConfiguration)this.getConfiguration()).isEnableRoles()) {
            return ROLE_ITERATOR;
        }
        return this.getRoles(this.buildRoleFilter(WILDCARD_SEARCH, true), true);
    }

    protected Iterator<Role> getRoles() {
        return this.getRoles(this.buildRoleFilter(WILDCARD_SEARCH, true), true);
    }

    protected Iterator<Role> getRoles(Filter filter, final boolean applyFilters) {
        try {
            return this.ldapService.search(filter, new LdapService.ResultMapper<Role>(){

                @Override
                public Role apply(SearchResult result) throws NamingException {
                    return AbstractDirectoryConnector.this.mapRole(result);
                }

                @Override
                public boolean isApplyFilters() {
                    return applyFilters;
                }
            }, this.configureRoleSearchControls(this.ldapService.getSearchControls()));
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    protected Role mapRole(SearchResult result) throws NamingException {
        Attributes attributes = result.getAttributes();
        Attribute guidAttr = attributes.get(((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleGuidAttribute());
        String guid = guidAttr == null ? "" : StringUtil.nonNull((String)guidAttr.get().toString());
        String identityName = StringUtil.nonNull((String)attributes.get(((AbstractDirectoryConfiguration)this.getConfiguration()).getRoleNameAttribute()).get().toString());
        LdapName dn = new LdapName(result.getName().toString());
        NamingEnumeration<? extends Attribute> ne = attributes.getAll();
        DirectoryRole directoryRole = new DirectoryRole(guid, identityName, dn);
        while (ne.hasMoreElements()) {
            Attribute a = ne.next();
            if (a.getID().equals(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityGuidAttribute()) || a.getID().equals(((AbstractDirectoryConfiguration)this.getConfiguration()).getIdentityNameAttribute())) continue;
            ArrayList<String> vals = new ArrayList<String>();
            NamingEnumeration<?> ane = a.getAll();
            while (ane.hasMoreElements()) {
                Object val = ane.next();
                vals.add(val == null ? null : String.valueOf(val));
            }
            directoryRole.setAttribute(a.getID(), vals.toArray(new String[0]));
        }
        if (((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludedRoles().size() > 0 ? !((AbstractDirectoryConfiguration)this.getConfiguration()).getIncludedRoles().contains(identityName) : ((AbstractDirectoryConfiguration)this.getConfiguration()).getExcludedRoles().size() > 0 && ((AbstractDirectoryConfiguration)this.getConfiguration()).getExcludedRoles().contains(identityName)) {
            return null;
        }
        return directoryRole;
    }

    protected SearchControls configureSearchControls(SearchControls searchControls) {
        searchControls.setSearchScope(2);
        searchControls.setReturningObjFlag(true);
        return searchControls;
    }

    protected SearchControls configureRoleSearchControls(SearchControls searchControls) {
        searchControls.setSearchScope(2);
        searchControls.setReturningObjFlag(true);
        return searchControls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String getAttributeValue(Name dn, String attributeName) {
        try (LdapContext ctx = this.ldapService.lookupContext(dn);){
            Attributes attributes = ctx.getAttributes("", new String[]{attributeName, "rootDomainNamingContext"});
            String string = attributes.get(attributeName) != null ? attributes.get(attributeName).get().toString() : null;
            return string;
        }
        catch (NamingException ex) {
            this.processNamingException(ex);
            throw new IllegalStateException("Unreachable code");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    protected final String getByteValue(String attributeName, Attributes attributes) {
        try {
            byte[] objectGuid = (byte[])attributes.get(attributeName).get();
            if (objectGuid == null) {
                throw new IllegalArgumentException(attributeName + " cannot be null");
            }
            return StringUtil.convertByteToString((byte[])objectGuid);
        }
        catch (NamingException e) {
            this.processNamingException(e);
            throw new IllegalStateException("Unreachable code");
        }
    }

    protected void onOpen(P parameters) {
        try {
            this.ldapService = new LdapService();
            this.ldapService.setSocketFactory(this.socketFactory);
            this.ldapService.init((AbstractDirectoryConfiguration)((Object)parameters));
            this.ldapService.openConnection();
            Name baseDn = ((AbstractDirectoryConfiguration)((Object)parameters)).getBaseDn();
            LOG.info((Object)("Looking up " + baseDn));
        }
        catch (NamingException nme) {
            this.ldapService = null;
            this.processNamingException(nme);
        }
        catch (Exception e) {
            this.ldapService = null;
            throw new ConnectorException((Throwable)e);
        }
    }

    protected String processNamingException(NamingException nme) {
        if (nme instanceof CommunicationException) {
            if (nme.getRootCause() != null && nme.getRootCause().getClass().getName().equals("com.hypersocket.certificates.CertificateVerificationException")) {
                throw (RuntimeException)nme.getCause();
            }
            throw new ConnectorException(String.format("Failed to connect to %s", ((AbstractDirectoryConfiguration)this.getConfiguration()).getControllerHostnames()[0]), (Throwable)nme);
        }
        DirectoryExceptionParser dep = new DirectoryExceptionParser(nme);
        if (dep.getCode() == 49) {
            throw new InvalidLoginCredentialsException();
        }
        if (dep.getCode() == 53) {
            throw new InvalidLoginCredentialsException();
        }
        String message = dep.getMessage();
        throw new ConnectorException(message, (Throwable)nme);
    }

    protected String getReason(NamingException nme) {
        String message = this.getMessage(nme);
        if (!StringUtil.isNullOrEmpty((String)message)) {
            String string = "LDAP: error code ";
            int ldpx = message.indexOf("LDAP: error code ");
            if (ldpx != -1) {
                String err = message.substring(ldpx + "LDAP: error code ".length());
                StringTokenizer t = new StringTokenizer(err);
                t.nextToken();
                t.nextToken();
                String reason = t.nextToken();
                while (reason.endsWith(":")) {
                    reason = reason.substring(0, reason.length() - 1);
                }
                return reason;
            }
        }
        return "Unknown reason";
    }

    protected int getCode(NamingException nme) {
        String message = this.getMessage(nme);
        if (!StringUtil.isNullOrEmpty((String)message)) {
            String string = "LDAP: error code ";
            int ldpx = message.indexOf("LDAP: error code ");
            if (ldpx != -1) {
                String err = message.substring(ldpx + "LDAP: error code ".length());
                StringTokenizer t = new StringTokenizer(err);
                return Integer.parseInt(t.nextToken());
            }
        }
        return 0;
    }

    protected String getMessage(NamingException nme) {
        String message = nme.getExplanation();
        if (StringUtil.isNullOrEmpty((String)message)) {
            return StringUtil.isNullOrEmpty((String)nme.getMessage()) ? "No actual error message supplied." : nme.getMessage();
        }
        if (message.startsWith("[")) {
            message = message.substring(1);
        }
        if (message.endsWith("]")) {
            message = message.substring(0, message.length() - 1);
        }
        return message;
    }

    public Iterator<BrowseNode> getBrowseableNodes(BrowseNode parent) {
        SearchControls ctrls = new SearchControls();
        ctrls.setSearchScope(0);
        ctrls.setReturningObjFlag(true);
        try {
            Iterator<List<BrowseNode>> nodes = this.ldapService.search(new LdapName(parent.toString()), new Eq(OBJECT_CLASS_ATTRIBUTE, WILDCARD_SEARCH), new LdapService.ResultMapper<List<BrowseNode>>(){

                @Override
                public List<BrowseNode> apply(SearchResult result) throws NamingException {
                    Attribute namingContexts = result.getAttributes().get("namingContexts");
                    if (namingContexts == null) {
                        return Collections.emptyList();
                    }
                    NamingEnumeration<?> enumeration = namingContexts.getAll();
                    ArrayList<BrowseNode> l = new ArrayList<BrowseNode>();
                    while (enumeration.hasMore()) {
                        final String node = (String)enumeration.next();
                        l.add(new BrowseNode(){

                            public boolean isLeaf() {
                                return false;
                            }

                            public String toString() {
                                return node;
                            }
                        });
                    }
                    return l;
                }

                @Override
                public boolean isApplyFilters() {
                    return true;
                }
            }, this.ldapService.getSearchControls());
            return nodes.hasNext() ? nodes.next().iterator() : new ArrayList().iterator();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

