/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.connector.jndi.directory;

import com.identity4j.util.StringUtil;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public class DirectoryExceptionParser {
    private String reason = "Unknown";
    private String data = "";
    private int code;
    private String ldapError;
    private String message;

    public DirectoryExceptionParser(NamingException nme) {
        this.parse(nme);
    }

    protected String parseMessage(NamingException nme) {
        String message = nme.getExplanation();
        if (StringUtil.isNullOrEmpty((String)message)) {
            return StringUtil.isNullOrEmpty((String)nme.getMessage()) ? "No actual error message supplied." : nme.getMessage();
        }
        if (message.startsWith("[")) {
            message = message.substring(1);
        }
        if (message.endsWith("]")) {
            message = message.substring(0, message.length() - 1);
        }
        return message;
    }

    private void parse(NamingException nme) {
        this.message = this.parseMessage(nme);
        if (!StringUtil.isNullOrEmpty((String)this.message)) {
            String string = "LDAP: error code ";
            int ldpx = this.message.indexOf("LDAP: error code ");
            if (ldpx != -1) {
                String err = this.message.substring(ldpx + "LDAP: error code ".length());
                StringTokenizer t = new StringTokenizer(err, " ,:");
                this.code = Integer.parseInt(t.nextToken());
                t.nextToken();
                this.reason = this.stripTrailing(t.nextToken());
                t.nextToken();
                if (t.hasMoreTokens()) {
                    this.ldapError = t.nextToken();
                }
                while (t.hasMoreTokens()) {
                    if (!t.nextToken().equals("data")) continue;
                    this.data = t.nextToken();
                }
            }
        }
    }

    protected String stripTrailing(String text) {
        while (text.endsWith(":")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLdapError() {
        return this.ldapError;
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public String getData() {
        return this.data;
    }
}

