/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.connector.jndi.directory;

import com.identity4j.connector.exception.ConnectorException;
import com.identity4j.connector.jndi.directory.AbstractDirectoryConfiguration;
import com.identity4j.connector.jndi.directory.DirectoryConfiguration;
import com.identity4j.connector.jndi.directory.SearchResultsIterator;
import com.identity4j.connector.jndi.directory.ThreadLocalSocketFactory;
import com.identity4j.connector.jndi.directory.filter.And;
import com.identity4j.connector.jndi.directory.filter.Eq;
import com.identity4j.connector.jndi.directory.filter.Filter;
import com.identity4j.util.crypt.impl.DefaultEncoderManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapService {
    private static final String LDAP_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    static final Log LOG = LogFactory.getLog(LdapService.class);
    public static final String WILDCARD_SEARCH = "*";
    public static final String OBJECT_CLASS_ATTRIBUTE = "objectClass";
    private AbstractDirectoryConfiguration configuration;
    private SocketFactory socketFactory;
    private Hashtable<String, String> env = new Hashtable();

    public void openConnection() throws NamingException, IOException {
        this.checkLDAPHost();
        this.env.put("java.naming.security.principal", this.configuration.getServiceAccountDn());
        this.env.put("java.naming.security.credentials", this.configuration.getServiceAccountPassword());
        this.env.putAll(this.configuration.getConnectorConfigurationParameters());
        this.env.put("java.naming.provider.url", this.configuration.buildProviderUrl(this.configuration.getSecurityProtocol().equalsIgnoreCase("ssl"), this.configuration.getControllerHosts()));
        this.configureSocket(this.env);
        this.lookupContext(this.configuration.getBaseDn());
    }

    private void configureSocket(Hashtable<String, String> env) {
        env.put("com.sun.jndi.ldap.connect.pool", "false");
        env.put("com.sun.jndi.ldap.connect.pool.debug", "all");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getConnection(Control ... controls) throws NamingException {
        if (this.socketFactory != null) {
            this.env.put(LDAP_SOCKET_FACTORY, ThreadLocalSocketFactory.class.getName());
            ThreadLocalSocketFactory.set(this.socketFactory);
        }
        this.configureSocket(this.env);
        try {
            InitialLdapContext ctx = new InitialLdapContext(this.env, null);
            ctx.setRequestControls(controls);
            InitialLdapContext initialLdapContext = ctx;
            return initialLdapContext;
        }
        finally {
            if (this.socketFactory != null) {
                ThreadLocalSocketFactory.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getConnection(String account, String password) throws NamingException, IOException {
        Hashtable<String, String> env = new Hashtable<String, String>(this.configuration.getConnectorConfigurationParameters());
        env.put("java.naming.provider.url", this.configuration.buildProviderUrl(this.configuration.getSecurityProtocol().equalsIgnoreCase("ssl"), this.configuration.getControllerHosts()));
        env.put("java.naming.security.principal", account);
        env.put("java.naming.security.credentials", password);
        if (this.socketFactory != null) {
            env.put(LDAP_SOCKET_FACTORY, ThreadLocalSocketFactory.class.getName());
            ThreadLocalSocketFactory.set(this.socketFactory);
        }
        this.configureSocket(env);
        try {
            InitialDirContext initialDirContext = new InitialDirContext(env);
            return initialDirContext;
        }
        finally {
            if (this.socketFactory != null) {
                ThreadLocalSocketFactory.remove();
            }
        }
    }

    public void authenticate(String account, String password) throws IOException, NamingException {
        this.close(this.getConnection(account, password));
    }

    public void setPassword(final String account, final char[] newPassword) throws NamingException, IOException {
        this.processBlock(new Block<Void>(){

            @Override
            public Void apply(LdapContext context) throws NamingException {
                ModificationItem[] mods = new ModificationItem[1];
                byte[] encodedPassword = DefaultEncoderManager.getInstance().encode(newPassword, LdapService.this.configuration.getIdentityPasswordEncoding(), "UTF-8", null, null);
                BasicAttribute attribute = new BasicAttribute(LdapService.this.configuration.getIdentityPasswordAttribute(), encodedPassword);
                mods[0] = new ModificationItem(2, attribute);
                context.modifyAttributes(account, mods);
                return null;
            }
        }, new Control[0]);
    }

    public void setPassword(final String account, final byte[] encodedPassword, Control ... controls) throws NamingException, IOException {
        this.processBlock(new Block<Void>(){

            @Override
            public Void apply(LdapContext context) throws NamingException {
                ModificationItem[] mods = new ModificationItem[1];
                BasicAttribute attribute = new BasicAttribute(LdapService.this.configuration.getIdentityPasswordAttribute(), encodedPassword);
                mods[0] = new ModificationItem(2, attribute);
                context.modifyAttributes(account, mods);
                return null;
            }
        }, controls);
    }

    public void close() {
    }

    private void close(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public SearchControls getSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        return searchControls;
    }

    LdapService() {
    }

    public void init(AbstractDirectoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void rename(final LdapName currentDN, final LdapName newDN) throws NamingException, IOException {
        this.processBlock(new Block<Void>(){

            @Override
            public Void apply(LdapContext context) throws NamingException, IOException {
                context.rename(currentDN, newDN);
                return null;
            }
        }, new Control[0]);
    }

    public Attributes getAttributes(final Name dn) throws NamingException, IOException {
        return this.processBlock(new Block<Attributes>(){

            @Override
            public Attributes apply(LdapContext context) throws NamingException, IOException {
                return context.getAttributes(dn);
            }
        }, new Control[0]);
    }

    public <T> Iterator<T> search(Filter filter, ResultMapper<T> resultMapper, SearchControls searchControls) throws NamingException, IOException {
        return this.search(this.configuration.getBaseDn(), filter, resultMapper, searchControls);
    }

    public <T> Iterator<T> search(final Name baseDN, final Filter filter, final ResultMapper<T> resultMapper, final SearchControls searchControls) throws NamingException, IOException {
        return (Iterator)this.processBlockNoClose(new Block<Iterator<T>>(){

            @Override
            public Iterator<T> apply(LdapContext context) throws IOException, NamingException {
                return new SearchResultsIterator(Arrays.asList(baseDN), filter, searchControls, LdapService.this.configuration, resultMapper, context);
            }
        }, new Control[0]);
    }

    public void unbind(final Name name) throws NamingException, IOException {
        this.processBlock(new Block<Void>(){

            @Override
            public Void apply(LdapContext context) throws NamingException, IOException {
                context.unbind(name);
                return null;
            }
        }, new Control[0]);
    }

    public void update(final Name name, final ModificationItem ... mods) throws NamingException, IOException {
        this.processBlock(new Block<Void>(){

            @Override
            public Void apply(LdapContext context) throws NamingException, IOException {
                context.modifyAttributes(name, mods);
                return null;
            }
        }, new Control[0]);
    }

    public void bind(final Name name, final Attribute ... attrs) throws NamingException, IOException {
        this.processBlock(new Block<Void>(){

            @Override
            public Void apply(LdapContext context) throws NamingException, IOException {
                BasicAttributes attributes = new BasicAttributes();
                for (Attribute attribute : attrs) {
                    attributes.put(attribute);
                }
                context.bind(name, null, (Attributes)attributes);
                return null;
            }
        }, new Control[0]);
    }

    public Attribute getRootDSEAttribute(final String name) throws NamingException, IOException {
        return this.processBlock(new Block<Attribute>(){

            @Override
            public Attribute apply(LdapContext context) throws NamingException {
                Attributes attributes = context.getAttributes("", new String[]{name});
                return attributes.get(name) != null ? attributes.get(name) : null;
            }
        }, new Control[0]);
    }

    public LdapContext lookupContext(final Name dn) throws NamingException, IOException {
        return this.processBlock(new Block<LdapContext>(){

            @Override
            public LdapContext apply(LdapContext context) throws NamingException {
                return (LdapContext)context.lookup(dn);
            }
        }, new Control[0]);
    }

    public final Filter buildObjectClassFilter(String objectClass, String principalNameFilterAttribute, String principalName) {
        And filter = new And();
        filter.add(new Eq(OBJECT_CLASS_ATTRIBUTE, objectClass));
        filter.add(new Eq(principalNameFilterAttribute, principalName));
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T processBlock(Block<T> block, Control ... controls) throws NamingException, IOException {
        LdapContext connection = this.getConnection(controls);
        try {
            T t = block.apply(connection);
            return t;
        }
        finally {
            this.close(connection);
        }
    }

    private <T> T processBlockNoClose(Block<T> block, Control ... controls) throws NamingException, IOException {
        return block.apply(this.getConnection(controls));
    }

    protected void checkLDAPHost() {
        for (String controllerHost : this.configuration.getControllerHosts()) {
            String host = DirectoryConfiguration.getControllerHostWithoutPort(controllerHost);
            if (!host.matches("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b")) continue;
            try {
                InetAddress addr = InetAddress.getByName(host);
                if (!addr.getHostName().equals(host)) continue;
                throw new ConnectorException("IP " + controllerHost + " is not resolvable by a reverse DNS. Check your DNS configuration. If this error persists try adding an entry for " + controllerHost + " to your system HOSTS file.");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static interface Block<T> {
        public T apply(LdapContext var1) throws NamingException, IOException;
    }

    public static interface ResultMapper<T> {
        public T apply(SearchResult var1) throws NamingException, IOException;

        public boolean isApplyFilters();
    }
}

