/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.connector.jndi.directory;

import com.identity4j.connector.jndi.directory.AbstractDirectoryConfiguration;
import com.identity4j.connector.jndi.directory.LdapService;
import com.identity4j.connector.jndi.directory.filter.Filter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchResultsIterator<T>
implements Iterator<T> {
    static final Log LOG = LogFactory.getLog(LdapService.class);
    private LdapService.ResultMapper<T> filteredMapper;
    private Name[] dns;
    private int dnIdx = 0;
    private T next;
    private Name dn;
    private Filter filter;
    private NamingEnumeration<SearchResult> listIterator;
    private LdapContext context;
    private SearchControls searchControls;
    private AbstractDirectoryConfiguration configuration;
    private byte[] cookie = null;

    public SearchResultsIterator(Collection<? extends Name> dns, Filter filter, SearchControls searchControls, AbstractDirectoryConfiguration configuration, LdapService.ResultMapper<T> filteredMapper, LdapContext context) {
        this.context = context;
        this.configuration = configuration;
        this.searchControls = searchControls;
        this.filteredMapper = filteredMapper;
        this.dns = dns == null ? null : dns.toArray(new Name[0]);
        this.filter = filter;
        LOG.info((Object)String.format("New search iterator using filter: %s for DNs: %s", filter == null ? "<none>" : filter.encode(), dns == null ? null : Arrays.asList(dns)));
    }

    @Override
    public boolean hasNext() {
        this.fetchNext();
        if (this.next == null) {
            this.close();
        }
        return this.next != null;
    }

    private void close() {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.context = null;
        }
    }

    @Override
    public T next() {
        try {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                this.close();
                throw new NoSuchElementException();
            }
            T t = this.next;
            return t;
        }
        catch (Error e) {
            this.close();
            throw e;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public void remove() {
    }

    void fetchNext() {
        if (this.next != null) {
            return;
        }
        this.next = null;
        boolean nullSearch = false;
        boolean nullSearchDone = false;
        Control[] prev = null;
        while (this.next == null) {
            if (this.dn == null) {
                if (this.dns == null && !nullSearchDone) {
                    nullSearch = true;
                    try {
                        this.dn = new LdapName("NULL");
                    }
                    catch (NamingException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                } else {
                    if (this.dnIdx >= this.dns.length) {
                        this.next = null;
                        return;
                    }
                    this.dn = this.dns[this.dnIdx++];
                }
                this.cookie = null;
            }
            while (this.next == null && (nullSearch || this.dn != null)) {
                nullSearchDone = true;
                nullSearch = false;
                if (this.listIterator == null) {
                    try {
                        prev = this.context.getRequestControls();
                        if (this.cookie != null) {
                            this.context.setRequestControls(new Control[]{new PagedResultsControl(this.configuration.getMaxPageSize(), this.cookie, true)});
                        } else {
                            this.context.setRequestControls(new Control[]{new PagedResultsControl(this.configuration.getMaxPageSize(), true)});
                        }
                        LOG.info((Object)String.format("Filter : %s", this.filter.encode()));
                        this.listIterator = this.context.search(this.dn, this.filter.encode(), this.searchControls);
                        continue;
                    }
                    catch (PartialResultException e) {
                        if (this.configuration.isFollowReferrals()) {
                            LOG.error((Object)"Following referrals is on but partial result was received", (Throwable)e);
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Partial resluts ignored: " + e.getExplanation()));
                        }
                        this.dn = null;
                        continue;
                    }
                    catch (NamingException e) {
                        LOG.error((Object)"Failed to get results", (Throwable)e);
                        this.closeListIterator();
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Failed to get results", (Throwable)e);
                        this.closeListIterator();
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
                Binding result = null;
                try {
                    while (this.next == null && this.listIterator.hasMoreElements()) {
                        result = (SearchResult)this.listIterator.nextElement();
                        if (this.filteredMapper.isApplyFilters()) {
                            LdapName resultName = new LdapName(result.getNameInNamespace());
                            boolean include = this.configuration.getIncludes().isEmpty();
                            if (!include) {
                                for (Name name : this.configuration.getIncludes()) {
                                    if (!resultName.startsWith(name)) continue;
                                    include = true;
                                    break;
                                }
                            }
                            for (Name name : this.configuration.getExcludes()) {
                                if (!resultName.startsWith(name)) continue;
                                include = false;
                                break;
                            }
                            if (!include) continue;
                        }
                        this.next = this.filteredMapper.apply((SearchResult)result);
                    }
                    if (this.next != null) continue;
                    try {
                        Control[] controls = this.context.getResponseControls();
                        if (controls != null) {
                            for (int i = 0; i < controls.length; ++i) {
                                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)controls[i];
                                this.cookie = pagedResultsResponseControl.getCookie();
                            }
                        }
                    }
                    catch (NamingException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    finally {
                        if (prev != null) {
                            this.context.setRequestControls(prev);
                            prev = null;
                        }
                    }
                    this.closeListIterator();
                    if (this.cookie != null) continue;
                    this.dn = null;
                }
                catch (PartialResultException e) {
                    if (this.configuration.isFollowReferrals()) {
                        LOG.error((Object)"Following referrals is on but partial result was received", (Throwable)e);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Partial resuts ignored: " + e.getExplanation()));
                }
                catch (NamingException e) {
                    LOG.error((Object)"Failed to get results", (Throwable)e);
                    this.closeListIterator();
                    throw new IllegalStateException(e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to get results", (Throwable)e);
                    this.closeListIterator();
                    throw new IllegalStateException(e.getMessage(), e);
                }
                finally {
                    if (result == null || result.getObject() == null) continue;
                    try {
                        ((Context)result.getObject()).close();
                    }
                    catch (NamingException e) {
                        LOG.error((Object)"Failed to close object", (Throwable)e);
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected void closeListIterator() {
        if (this.listIterator != null) {
            try {
                this.listIterator.close();
            }
            catch (NamingException namingException) {
            }
            finally {
                this.listIterator = null;
            }
        }
    }
}

