/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.connector.jndi.directory.filter;

import com.identity4j.connector.jndi.directory.filter.Filter;

public abstract class CriteriaFilter
implements Filter {
    private String name;
    private String value;
    private String op;

    public CriteriaFilter(String name, String value) {
        this("=", name, value);
    }

    public CriteriaFilter(String op, String name, String value) {
        this.op = op;
        this.name = name;
        this.value = value;
    }

    @Override
    public String encode() {
        StringBuilder bui = new StringBuilder("(");
        bui.append(this.name);
        bui.append(this.op);
        bui.append(this.value);
        bui.append(")");
        return bui.toString();
    }

    protected static String escape(String name) {
        return CriteriaFilter.escape(name, true);
    }

    protected static String escape(String name, boolean escapeWildcard) {
        name = name.replace("(", "\\28").replace("|", "\\7c").replace("<", "\\3c").replace("/", "\\2f").replace(")", "\\29").replace("~", "\\7e").replace("\\", "\\5c").replace("&", "\\26").replace(">", "\\3e");
        if (escapeWildcard) {
            name = name.replace("*", "\\2a");
        }
        return name;
    }

    public String toString() {
        return this.getClass().getName() + " [name=" + this.name + ", value=" + this.value + ", op=" + this.op + ", encoded=" + this.encode() + "]";
    }
}

