/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractFilteredIterator<E>
implements Iterator<E> {
    private Iterator<E> sourceIterator;
    private E next;

    public AbstractFilteredIterator(Iterator<E> sourceIterator) {
        this.sourceIterator = sourceIterator;
    }

    @Override
    public boolean hasNext() {
        this.checkNext();
        return this.next != null;
    }

    @Override
    public E next() {
        this.checkNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.next;
            return e;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public void remove() {
    }

    private void checkNext() {
        if (this.next == null) {
            E n;
            while (this.sourceIterator.hasNext() && (n = this.sourceIterator.next()) != null) {
                if (n == null || !this.include(n)) continue;
                this.next = n;
                break;
            }
        }
    }

    protected abstract boolean include(E var1);
}

