/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractLazyLoadingIterator<T>
implements Iterator<T> {
    private Iterator<T> itr;
    private T nextItem;

    @Override
    public final boolean hasNext() {
        this.lazyInitialise();
        if (this.itr != null && this.itr.hasNext()) {
            return true;
        }
        if (this.nextItem == null) {
            return false;
        }
        this.itr = this.fetchNext();
        return this.itr != null && this.itr.hasNext();
    }

    @Override
    public final T next() {
        this.lazyInitialise();
        if (this.itr == null) {
            throw new NoSuchElementException("iterator has no more elements");
        }
        T next = this.itr.next();
        this.nextItem = next;
        this.onNext(next);
        return next;
    }

    private void lazyInitialise() {
        if (this.itr == null) {
            this.itr = this.fetchNext();
        }
    }

    protected void onNext(T next) {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported on this Iterator");
    }

    protected abstract Iterator<T> fetchNext();
}

