/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractTransformingIterator<E, O>
implements Iterator<O> {
    private Iterator<E> sourceIterator;
    private O next;

    public AbstractTransformingIterator(Iterator<E> sourceIterator) {
        this.sourceIterator = sourceIterator;
    }

    @Override
    public boolean hasNext() {
        this.checkNext();
        return this.next != null;
    }

    @Override
    public O next() {
        this.checkNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        try {
            O o = this.next;
            return o;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public void remove() {
    }

    private void checkNext() {
        if (this.next == null) {
            E n;
            while (this.sourceIterator.hasNext() && (n = this.sourceIterator.next()) != null) {
                O enext;
                if (n == null || (enext = this.transform(n)) == null) continue;
                this.next = enext;
                break;
            }
        }
    }

    protected abstract O transform(E var1);
}

