/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import com.identity4j.util.RGB;

public class Color
implements RGB {
    private static final long serialVersionUID = 6211754997254209905L;
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color DARK_GREEN = new Color(0, 128, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color DARK_RED = new Color(128, 0, 0);
    private int red;
    private int green;
    private int blue;

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(String hex) {
        if (hex == null || hex.trim().equals("")) {
            this.red = 0;
            this.green = 0;
            this.blue = 0;
        } else {
            while (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            if (hex.length() == 3) {
                this.red = Integer.parseInt(hex.substring(0, 1), 16) * 16;
                this.green = Integer.parseInt(hex.substring(1, 2), 16) * 16;
                this.blue = Integer.parseInt(hex.substring(2, 3), 16) * 16;
            } else if (hex.length() == 6) {
                this.red = Integer.parseInt(hex.substring(0, 2), 16);
                this.green = Integer.parseInt(hex.substring(2, 4), 16);
                this.blue = Integer.parseInt(hex.substring(4, 6), 16);
            } else {
                throw new IllegalArgumentException("'" + hex + "' not a hex colour");
            }
        }
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    public static String toHexString(RGB color) {
        if (color == null) {
            return "auto";
        }
        return "#" + Color.toHexNumber(color);
    }

    public static String toHexNumber(RGB color) {
        return Color.toHexDigits(color.getRed()) + Color.toHexDigits(color.getGreen()) + Color.toHexDigits(color.getBlue());
    }

    public static String toHexDigits(int value) {
        return String.format("%02X", value);
    }
}

