/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class Extender
implements Serializable {
    private static final ThreadLocal<Extension> extension = new ThreadLocal();

    public abstract void extend(String var1, String var2) throws Exception;

    protected Extension getExtension() {
        return extension.get();
    }

    public static Map<String, String> extend(String service) {
        return Extender.extend(new Extender(){

            @Override
            public void extend(String name, String parameter) throws Exception {
            }
        }, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> extend(Extender extender, String service) {
        try {
            int lastOrder = 0;
            HashMap<String, String> m = new HashMap<String, String>();
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = extender.getClass().getClassLoader();
            }
            Enumeration<URL> urle = cl.getResources("META-INF/services/" + service);
            while (urle.hasMoreElements()) {
                URL serviceUrl = urle.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(serviceUrl.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                        int idx = line.indexOf("=");
                        String name = line;
                        String param = null;
                        if (idx != -1) {
                            name = line.substring(0, idx).trim();
                            param = line.substring(idx + 1).trim();
                        }
                        int order = lastOrder + 100;
                        if (name.startsWith("[")) {
                            idx = name.indexOf("]");
                            order = Integer.parseInt(name.substring(1, idx));
                            name = name.substring(idx + 1);
                        }
                        lastOrder = order;
                        m.put(name, param);
                        extensions.add(new Extension(name, param, order, serviceUrl));
                    }
                }
            }
            Collections.sort(extensions);
            for (Extension e : extensions) {
                extension.set(e);
                extender.extend(e.name, e.parameter);
            }
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Extension
    implements Comparable<Extension>,
    Serializable {
        private String name;
        private String parameter;
        private int order;
        private URL source;

        public Extension(String name, String parameter, int order, URL source) {
            this.name = name;
            this.parameter = parameter;
            this.order = order;
            this.source = source;
        }

        public String getName() {
            return this.name;
        }

        public String getParameter() {
            return this.parameter;
        }

        public int getOrder() {
            return this.order;
        }

        public URL getSource() {
            return this.source;
        }

        @Override
        public int compareTo(Extension other) {
            int o = new Integer(this.order).compareTo(new Integer(other.order));
            return o == 0 ? this.name.compareTo(other.name) : o;
        }
    }
}

