/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class IOUtil {
    public static InputStream getStreamFromResource(Class<?> clazz, String resourceName) throws IOException {
        if (resourceName.startsWith("res://") && clazz != null) {
            URL url = clazz.getResource(resourceName.substring(6));
            if (url == null) {
                throw new FileNotFoundException("Resource " + resourceName + " not found on CLASSPATH.");
            }
            return url.openStream();
        }
        try {
            URL url = new URL(resourceName);
            return url.openStream();
        }
        catch (MalformedURLException murle) {
            File file = new File(resourceName);
            return new FileInputStream(file);
        }
    }

    public static String getStringFromResource(Class<?> clazz, String resourceName) throws IOException {
        return IOUtil.getStringFromResource(clazz, resourceName, null);
    }

    public static String getStringFromResource(Class<?> clazz, String resourceName, String charset) throws IOException {
        try (InputStream in = IOUtil.getStreamFromResource(clazz, resourceName);){
            String string = IOUtils.toString((InputStream)in, (String)(charset == null ? Charset.defaultCharset().name() : charset));
            return string;
        }
    }
}

