/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import com.identity4j.util.MultiMapException;
import com.identity4j.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MultiMap
implements Serializable,
Map<String, String[]> {
    private static final long serialVersionUID = 2939486586092126095L;
    private static final String[] EMPTY_ARRAY = new String[0];
    private Map<String, String[]> values = new HashMap<String, String[]>();

    public static MultiMap fromMapSingle(Map<String, String> values) {
        MultiMap m = new MultiMap();
        for (Map.Entry<String, String> s : values.entrySet()) {
            m.put(s.getKey(), new String[]{s.getValue()});
        }
        return m;
    }

    public static MultiMap fromMap(Map<String, String[]> map) {
        MultiMap mm = new MultiMap();
        mm.values = map;
        return mm;
    }

    public MultiMap() {
    }

    public MultiMap(Map<String, String[]> values) {
        this.values.putAll(values);
    }

    public void setAll(Map<String, String[]> values) {
        this.values.putAll(values);
    }

    public String[] setMore(String key, String ... values) {
        String[] oldValue = this.getStringArray(key);
        ArrayList<String> more = new ArrayList<String>(Arrays.asList(oldValue));
        more.addAll(Arrays.asList(values));
        return this.set(key, more);
    }

    public String[] set(String key, String ... values) {
        return this.values.put(key, values);
    }

    public String[] set(String key, Collection<String> values) {
        if (values == null) {
            return this.set(key, (String[])null);
        }
        return this.set(key, values.toArray(new String[values.size()]));
    }

    public final String getString(String key) {
        return StringUtil.nonNull(this.getStringOrNull(key));
    }

    public final String getStringOrDefault(String key, String defaultValue) {
        String value = this.getStringOrNull(key);
        return value == null ? defaultValue : value;
    }

    public final String getStringOrNull(String key) {
        String[] stringValues = this.values.get(key);
        if (stringValues != null && stringValues.length > 0) {
            return stringValues[0];
        }
        return null;
    }

    public final String getStringOrFail(String key) {
        String value = this.getStringOrNull(key);
        if (value == null) {
            throw new MultiMapException("Missing value for attribute '" + key + "'.");
        }
        return value;
    }

    public final String[] getStringArray(String key) {
        String[] values = this.getStringArrayOrNull(key);
        return values == null ? EMPTY_ARRAY : values;
    }

    public final String[] getStringArrayOrDefault(String key, String ... defaultValues) {
        String[] values = this.getStringArrayOrNull(key);
        return values == null ? defaultValues : values;
    }

    public final String[] getStringArrayOrNull(String key) {
        return this.values.get(key);
    }

    public final String[] getStringArrayOrFail(String key) {
        String[] values = this.getStringArrayOrNull(key);
        if (values == null) {
            throw new MultiMapException("Missing value for attribute '" + key + "'.");
        }
        return values;
    }

    public final Boolean getBoolean(String key) {
        Boolean value = this.getBooleanOrNull(key);
        return value == null ? Boolean.FALSE : value;
    }

    public final Boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String value = this.getStringOrNull(key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public final Boolean getBooleanOrNull(String key) {
        String value = this.getStringOrNull(key);
        return value == null ? null : Boolean.valueOf(value);
    }

    public final Boolean getBooleanOrFail(String key) {
        String value = this.getStringOrFail(key);
        return Boolean.valueOf(value);
    }

    public final Integer getInteger(String key) {
        Integer value = this.getIntegerOrNull(key);
        return value == null ? Integer.valueOf(-1) : value;
    }

    public final Integer getIntegerOrDefault(String key, Integer defaultValue) {
        Integer value = this.getIntegerOrNull(key);
        return value == null ? defaultValue : value;
    }

    public final Integer getIntegerOrNull(String key) {
        String value = this.getStringOrNull(key);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public final Integer getIntegerOrFail(String key) {
        try {
            String value = this.getStringOrFail(key);
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new MultiMapException("Unable to obtain Integer value for key '" + key + "'.", nfe);
        }
    }

    public final Map<String, String> getMap(String key) {
        String[] values = this.getStringArrayOrNull(key);
        return values == null ? Collections.emptyMap() : this.toMap(values);
    }

    public final Map<String, String> getMapOrDefault(String key, Map<String, String> defaultValue) {
        String[] values = this.getStringArrayOrNull(key);
        return values == null ? defaultValue : this.toMap(values);
    }

    public final Map<String, String> getMapOrNull(String key) {
        String[] values = this.getStringArrayOrNull(key);
        return values == null ? null : this.toMap(values);
    }

    public final Map<String, String> getMapOrFail(String key) {
        String[] values = this.getStringArrayOrFail(key);
        return this.toMap(values);
    }

    private Map<String, String> toMap(String[] values) {
        HashMap<String, String> toMap = new HashMap<String, String>();
        for (String value : values) {
            String[] split = value.split("=");
            if (split.length != 2) continue;
            String mapKey = split[0];
            String mapValue = split[1];
            if (StringUtil.isNullOrEmpty(mapKey) || StringUtil.isNullOrEmpty(mapValue)) continue;
            toMap.put(mapKey, mapValue);
        }
        return toMap;
    }

    public final Iterable<String> getKeyIterator() {
        return new HashSet<String>(this.values.keySet());
    }

    public final Map<String, String[]> toMap() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public final void clear() {
        this.values.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MultiMap)) {
            return false;
        }
        return this.values.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return this.values.toString();
    }

    public static MultiMap toMultiMap(Properties originalMap) {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (Map.Entry<Object, Object> entry : originalMap.entrySet()) {
            values.put(entry.getKey().toString(), StringUtil.toDefaultArray(entry.getValue().toString()));
        }
        return new MultiMap(values);
    }

    public static MultiMap toMultiMap(Map<String, String> originalMap) {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            values.put(entry.getKey(), StringUtil.toDefaultArray(entry.getValue()));
        }
        return new MultiMap(values);
    }

    public static Map<String, String> toMap(Map<String, String[]> map) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String key : map.keySet()) {
            m.put(key, StringUtil.toDefaultString(map.get(key)));
        }
        return m;
    }

    public void merge(MultiMap source) {
        this.values.putAll(source.values);
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String[]>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public String[] get(Object key) {
        return this.values.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public String[] put(String key, String[] value) {
        return this.values.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String[]> map) {
        this.values.putAll(map);
    }

    @Override
    public String[] remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<String[]> values() {
        return this.values.values();
    }
}

