/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class NetUtil {
    public static String getRPCURL() throws SocketException {
        String ifaces = System.getProperty("nervepoint.interfaces");
        StringTokenizer t = new StringTokenizer(ifaces, ",");
        while (t.hasMoreTokens()) {
            InetSocketAddress addr;
            String addrType = t.nextToken();
            if (!addrType.startsWith("https")) continue;
            int port = Integer.parseInt(System.getProperty("nervepoint." + addrType));
            String hostname = System.getProperty("nervepoint." + addrType + ".addr");
            if (hostname == null) {
                hostname = "0.0.0.0";
            }
            if ((addr = new InetSocketAddress(hostname, port)).getAddress().isAnyLocalAddress()) {
                addr = NetUtil.getBestAddress(addr);
            }
            return "https://" + addr.getHostName() + ":" + port + "/";
        }
        return null;
    }

    public static InetSocketAddress getBestAddress(InetSocketAddress addr) throws SocketException {
        Enumeration<NetworkInterface> networkIfs = NetworkInterface.getNetworkInterfaces();
        while (networkIfs.hasMoreElements()) {
            NetworkInterface networkIf = networkIfs.nextElement();
            if (networkIf.isLoopback() || !networkIf.isUp()) continue;
            boolean found = false;
            for (InterfaceAddress a : networkIf.getInterfaceAddresses()) {
                if (!a.getAddress().getClass().equals(addr.getAddress().getClass())) continue;
                addr = new InetSocketAddress(a.getAddress(), addr.getPort());
                found = true;
            }
            if (!found) continue;
            break;
        }
        return addr;
    }
}

