/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String nonNull(String value) {
        return value == null ? "" : value;
    }

    public static String trim(String value) {
        return value == null ? "" : value.trim();
    }

    public static String getBefore(String value, String match) {
        int indexOf;
        int n = indexOf = value == null ? -1 : value.indexOf(match);
        if (indexOf == -1 || indexOf == value.length()) {
            return StringUtil.nonNull(value);
        }
        return value.substring(0, indexOf);
    }

    public static String getBeforeLast(String value, String match) {
        int indexOf;
        int n = indexOf = value == null ? -1 : value.lastIndexOf(match);
        if (indexOf == -1 || indexOf == value.length()) {
            return StringUtil.nonNull(value);
        }
        return value.substring(0, indexOf);
    }

    public static String getAfterLast(String value, String match) {
        int indexOf;
        int n = indexOf = value == null ? -1 : value.lastIndexOf(match);
        if (indexOf == -1 || indexOf == value.length()) {
            return StringUtil.nonNull(value);
        }
        return value.substring(indexOf + match.length(), value.length());
    }

    public static String getAfter(String value, String match) {
        int indexOf;
        int n = indexOf = value == null ? -1 : value.indexOf(match);
        if (indexOf == -1 || indexOf == value.length()) {
            return StringUtil.nonNull(value);
        }
        return value.substring(indexOf + match.length(), value.length());
    }

    public static String[] toDefaultArray(String value) {
        List<String> list = StringUtil.toDefaultList(value);
        return list.toArray(new String[list.size()]);
    }

    public static String[] toArray(String value, char delimiter) {
        List<String> list = StringUtil.toList(value, delimiter);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> toDefaultList(String value) {
        return StringUtil.toList(value, '!');
    }

    public static List<String> toList(String value, char delimiter) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        boolean escape = false;
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\\' && !escape) {
                escape = true;
                continue;
            }
            if (!escape && ch == delimiter) {
                values.add(word.toString());
                word.setLength(0);
                continue;
            }
            if (escape && ch == 'n') {
                word.append('\n');
            } else if (escape && ch == 'r') {
                word.append('\r');
            } else if (escape && ch == 't') {
                word.append('\t');
            } else {
                word.append(ch);
            }
            escape = false;
        }
        if (values.size() > 0 || word.length() > 0) {
            values.add(word.toString());
        }
        return values;
    }

    public static String toDefaultString(String ... values) {
        return StringUtil.toString("!", values);
    }

    public static String toString(String delimiter, String ... values) {
        if (values == null) {
            return "";
        }
        return StringUtil.toString(Arrays.asList(values), delimiter);
    }

    public static String toDefaultString(Collection<String> values) {
        return StringUtil.toString(values, "!");
    }

    public static String toString(Collection<String> values, String delimiter) {
        if (values == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int delim = 0;
        for (String value : values) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            for (char ch : value.toCharArray()) {
                if (delim < delimiter.length() && ch == delimiter.charAt(delim)) {
                    if (++delim != delimiter.length()) continue;
                    builder.append('\\');
                    builder.append(delimiter);
                    delim = 0;
                    continue;
                }
                if (ch == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (ch == '\r') {
                    builder.append("\\r");
                    continue;
                }
                if (ch == '\t') {
                    builder.append("\\t");
                    continue;
                }
                if (ch == '\\') {
                    builder.append("\\\\");
                    continue;
                }
                builder.append(ch);
            }
        }
        return builder.toString();
    }

    public static boolean equals(Collection<String> asCollection, String[] values) {
        List<String> asList = Arrays.asList(values);
        boolean containsAll = asCollection.containsAll(asList);
        int size = asCollection.size();
        int length = values.length;
        return containsAll && length == size;
    }

    public static final String convertByteToString(byte[] objectGuid) {
        StringBuilder builder = new StringBuilder();
        for (byte element : objectGuid) {
            int item = element & 0xFF;
            if (item <= 15) {
                builder.append("0");
            }
            builder.append(Integer.toHexString(item));
        }
        return builder.toString();
    }

    public static String upperCamelCase(String value) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(value, " .", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(" ")) continue;
            if (token.equals(".")) {
                builder.append(".");
                continue;
            }
            builder.append(Character.toUpperCase(token.charAt(0)));
            if (token.length() <= 1) continue;
            builder.append(token.substring(1));
        }
        return builder.toString();
    }

    public static String getURLFilename(URL url) {
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static String getLastToken(String string, String lastToken) {
        int idx = string.lastIndexOf(lastToken);
        if (idx == -1) {
            return string;
        }
        return string.substring(idx + lastToken.length());
    }

    public static String compactClasspathString(String classpathString) {
        return classpathString.replace(System.getProperty("user.dir"), ".").replace(System.getProperty("user.home"), "~");
    }

    public static boolean isArrayNullOrEmpty(String[] values) {
        return values == null || values.length == 0;
    }

    public static boolean isNullOrEmptyOrFirstElementBlank(String[] values) {
        return StringUtil.isArrayNullOrEmpty(values) || values[0].equals("");
    }

    public static String getValue(String[] values) {
        return values == null || values.length == 0 ? null : values[0];
    }

    public static String trimToLength(String text, int length) {
        return text.length() > length ? text.substring(0, length) + " ...." : text;
    }

    public static String getFirstItemOrNull(List<String> items) {
        return items == null || items.size() == 0 ? null : items.get(0);
    }

    public static String capitalisedToKey(String name) {
        boolean capNext = true;
        StringBuilder bui = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (Character.isLetter(c)) {
                if (capNext) {
                    bui.append(Character.toUpperCase(c));
                    capNext = false;
                    continue;
                }
                bui.append(c);
                continue;
            }
            if (Character.isDigit(c)) {
                bui.append(c);
                continue;
            }
            capNext = true;
        }
        return bui.toString();
    }

    public static List<String> toList(String value, String delimiter) {
        ArrayList<String> collection = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, delimiter);
        while (tokenizer.hasMoreElements()) {
            collection.add(tokenizer.nextToken());
        }
        return collection;
    }
}

