/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);
    public static Date MAX_DATE = new Date(Long.MAX_VALUE);

    private Util() {
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return Util.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isToday(Date date) {
        return Util.isSameDay(date, Calendar.getInstance().getTime());
    }

    public static boolean isToday(Calendar cal) {
        return Util.isSameDay(cal, Calendar.getInstance());
    }

    public static boolean isBeforeDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return Util.isBeforeDay(cal1, cal2);
    }

    public static boolean isBeforeDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        if (cal1.get(0) < cal2.get(0)) {
            return true;
        }
        if (cal1.get(0) > cal2.get(0)) {
            return false;
        }
        if (cal1.get(1) < cal2.get(1)) {
            return true;
        }
        if (cal1.get(1) > cal2.get(1)) {
            return false;
        }
        return cal1.get(6) < cal2.get(6);
    }

    public static boolean isAfterDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return Util.isAfterDay(cal1, cal2);
    }

    public static boolean isAfterDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        if (cal1.get(0) < cal2.get(0)) {
            return false;
        }
        if (cal1.get(0) > cal2.get(0)) {
            return true;
        }
        if (cal1.get(1) < cal2.get(1)) {
            return false;
        }
        if (cal1.get(1) > cal2.get(1)) {
            return true;
        }
        return cal1.get(6) > cal2.get(6);
    }

    public static boolean isWithinDaysFuture(Date date, int days) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return Util.isWithinDaysFuture(cal, days);
    }

    public static boolean isWithinDaysFuture(Calendar cal, int days) {
        if (cal == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar today = Calendar.getInstance();
        Calendar future = Calendar.getInstance();
        future.add(6, days);
        return Util.isAfterDay(cal, today) && !Util.isAfterDay(cal, future);
    }

    public static Date getStart(Date date) {
        return Util.clearTime(date);
    }

    public static Date clearTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean hasTime(Date date) {
        if (date == null) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (c.get(11) > 0) {
            return true;
        }
        if (c.get(12) > 0) {
            return true;
        }
        if (c.get(13) > 0) {
            return true;
        }
        return c.get(14) > 0;
    }

    public static Date getEnd(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date max(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return null;
        }
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.after(d2) ? d1 : d2;
    }

    public static Date min(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return null;
        }
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.before(d2) ? d1 : d2;
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> l = new ArrayList<T>();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    public static int countIterator(Iterator<?> it) {
        int x = 0;
        while (it.hasNext()) {
            it.next();
            ++x;
        }
        return x;
    }

    public static String traceString(Throwable t) {
        StringWriter s = new StringWriter();
        t.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public static Locale parseLocale(String languageCountry) {
        String[] els = languageCountry.split("_");
        if (els.length == 2) {
            return new Locale(els[0], els[1]);
        }
        if (els.length == 3) {
            return new Locale(els[0], els[1], els[2]);
        }
        return new Locale(els[0]);
    }

    public static boolean isDatePast(Date fromDate, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fromDate);
        calendar.add(5, days);
        return new Date().after(calendar.getTime());
    }

    public static Date futureDate(long days) {
        return new Date(Util.futureTime(days));
    }

    public static long futureTime(long days) {
        return System.currentTimeMillis() + Util.daysToMillis(days);
    }

    public static long daysToMillis(long days) {
        return days * 24L * 60L * 60L * 1000L;
    }

    public static void assertNotNull(Object toCheck, String name) {
        if (toCheck == null) {
            throw new IllegalArgumentException(name + " must be set.");
        }
    }

    public static String fromObject(Object object) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Method m : object.getClass().getMethods()) {
            if (!m.getName().matches("get[A-Z]?.*") && !m.getName().matches("is[A-Z]?.*") || m.getParameterTypes().length != 0) continue;
            if (builder.length() > 1) {
                builder.append(", ");
            }
            String name = m.getName().startsWith("is") ? m.getName().substring(2) : m.getName().substring(3);
            builder.append(name);
            builder.append("=");
            try {
                builder.append(m.invoke(object, new Object[0]));
            }
            catch (Exception e) {
                builder.append("!Exception!");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static Calendar dayPrecision(Calendar calendar) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(calendar.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal;
    }

    public static void removeMe(String message, String ... args) {
        System.out.println("*** REMOVEME **** " + MessageFormat.format(message, args));
    }

    public static Throwable getRootCause(Throwable exception, Class<? extends Throwable> clazz) {
        Throwable cause = exception;
        Throwable root = null;
        do {
            if (cause == null || clazz != null && (clazz == null || !clazz.isAssignableFrom(cause.getClass()))) continue;
            root = cause;
        } while ((cause = cause.getCause()) != null);
        return root;
    }

    public static void randomSleep(long ms) {
        try {
            Thread.sleep((long)((double)ms * Math.random()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unzip(File zipfile, File directory) throws IOException {
        try (ZipFile zfile = new ZipFile(zipfile);){
            int files = 0;
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                try (InputStream in = zfile.getInputStream(entry);
                     FileOutputStream fos = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)fos);
                    LOG.info((Object)("Extracted " + file));
                    ++files;
                }
            }
            int n = files;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File directory, File zipfile) throws IOException {
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        FileOutputStream out = new FileOutputStream(zipfile);
        Closeable res = null;
        try {
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                directory = (File)queue.pop();
                for (File kid : directory.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    try (FileInputStream fin = new FileInputStream(kid);){
                        IOUtils.copy((InputStream)fin, (OutputStream)zout);
                    }
                    zout.closeEntry();
                }
            }
        }
        finally {
            if (res != null) {
                res.close();
            }
            ((OutputStream)out).close();
        }
    }

    public static boolean differs(Object o1, Object o2) {
        if (o1 == null && o2 != null || o2 == null && o1 != null) {
            return true;
        }
        if (o1 instanceof Date) {
            Date d1 = (Date)o1;
            Date d2 = (Date)o2;
            o1 = new Date(d1.getTime() / 1000L * 1000L);
            o2 = new Date(d2.getTime() / 1000L * 1000L);
        }
        return o1 != null && !o1.equals(o2);
    }

    public static void memDbg(String ctx) {
        if ("true".equalsIgnoreCase(System.getProperty("identity4j.memDbg", "false"))) {
            System.out.println(String.format("Total: %6d MiB   Free: %6d   Used: %6d   Max: %6d    Ctx: %s", Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L, (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L, Runtime.getRuntime().maxMemory() / 1024L / 1024L, ctx));
        }
    }
}

