/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util;

public class Version
implements Comparable<Version> {
    private int[] elements;
    private String versionString;

    public Version(String versionString) {
        this.parseFromString(versionString);
    }

    public void parseFromString(String versionString) {
        this.versionString = versionString;
        String[] stringElements = versionString.split("[^a-zA-Z0-9]+");
        if (stringElements.length < 3 || stringElements.length > 4) {
            throw new IllegalArgumentException("Version number be in the format <major>.<minor>.<release>[?TAG]");
        }
        if (stringElements.length == 3) {
            stringElements = new String[]{stringElements[0], stringElements[1], stringElements[2], "base"};
        }
        this.elements = new int[stringElements.length];
        int idx = 0;
        for (String string : stringElements) {
            String substring;
            int element = idx == 3 ? (string.equalsIgnoreCase("base") ? 0 : (string.toLowerCase().startsWith("ga") ? -199 + ((substring = string.substring(2)).equals("") ? 0 : Integer.parseInt(substring)) : (string.toLowerCase().startsWith("rc") ? -299 + ((substring = string.substring(2)).equals("") ? 0 : Integer.parseInt(substring)) : (string.toLowerCase().startsWith("beta") ? -399 + ((substring = string.substring(4)).equals("") ? 0 : Integer.parseInt(substring)) : (string.toLowerCase().startsWith("alpha") ? -499 + ((substring = string.substring(5)).equals("") ? 0 : Integer.parseInt(substring)) : (string.toLowerCase().startsWith("r") ? ((substring = string.substring(1)).equals("") ? 0 : Integer.parseInt(substring)) : Integer.parseInt(string))))))) : Integer.parseInt(string);
            this.elements[idx] = element;
            ++idx;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Version && ((Version)o).compareTo(this) == 0;
    }

    public int[] getVersionElements() {
        return this.elements;
    }

    public String toString() {
        return this.versionString;
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        int[] otherElements = version.getVersionElements();
        for (int i = 0; i < 4; ++i) {
            if (this.elements[i] == otherElements[i]) continue;
            return this.elements[i] - otherElements[i];
        }
        return 0;
    }
}

