/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt;

import com.identity4j.util.crypt.Encoder;
import com.identity4j.util.crypt.EncoderException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class EncoderManager {
    private Map<String, Encoder> encoders = new TreeMap<String, Encoder>();

    public Encoder getEncoderById(String id) {
        return this.encoders.get(id);
    }

    public void addEncoder(Encoder encoder) {
        if (this.encoders.containsKey(encoder.getId())) {
            throw new IllegalArgumentException("An encoder with the ID of " + encoder.getId() + " has already been registered.");
        }
        this.encoders.put(encoder.getId(), encoder);
    }

    public void removeEncoder(Encoder encoder) {
        if (!this.encoders.containsValue(encoder)) {
            throw new IllegalArgumentException("An encoder with the ID of " + encoder.getId() + " is not registered.");
        }
        this.encoders.remove(encoder.getId());
    }

    public Encoder getEncoderForEncodedString(char[] string, String charset, Collection<String> supportedEncoders) {
        try {
            byte[] data = new String(string).getBytes(charset);
            for (Encoder encoder : this.encoders.values()) {
                if (!encoder.isOfType(data, null)) continue;
                return encoder;
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee);
        }
        return null;
    }

    public Encoder getEncoderForEncodedData(byte[] encodedData, String charSet) {
        for (Encoder encoder : this.encoders.values()) {
            if (!encoder.isOfType(encodedData, charSet)) continue;
            return encoder;
        }
        return null;
    }

    public String[] getEncoderIds() {
        return this.encoders.keySet().toArray(new String[this.encoders.size()]);
    }

    public byte[] encode(char[] unencodedString, String encoderId, String charset, byte[] salt, byte[] passphrase) throws EncoderException {
        Encoder encoder = this.getEncoder(encoderId);
        try {
            return encoder.encode(new String(unencodedString).getBytes(charset), salt, passphrase, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    public char[] decode(byte[] encodedBytes, String encoderId, String charset, byte[] salt, byte[] passphrase) throws EncoderException {
        Encoder encoder = this.getEncoder(encoderId);
        try {
            return new String(encoder.decode(encodedBytes, null, passphrase, charset), charset).toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    protected Encoder getEncoder(String encoderId) {
        Encoder encoder;
        if (encoderId == null) {
            encoderId = "plain";
        }
        if ((encoder = this.getEncoderById(encoderId)) == null) {
            throw new IllegalArgumentException("Invalid encoder " + encoderId + ".");
        }
        return encoder;
    }
}

