/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.RawAESEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AESEncoder
extends RawAESEncoder {
    public static final String ID = "aesstring";
    private int iterations = 1024;

    public AESEncoder() {
        super(ID);
    }

    public AESEncoder(String id, int keyLength) {
        super(id, keyLength);
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        return this.encode(toEncode, salt, passphrase, charset, this.keyLength, this.iterations);
    }

    @Override
    protected byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset, int keyLength, int iterations) throws EncoderException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            if (salt == null) {
                salt = this.randomBytes(cipher.getBlockSize());
            }
            salt = this.checkSaltLength(salt, cipher);
            return this.write(keyLength, iterations, salt, super.encode(toEncode, salt, passphrase, charset, keyLength, iterations));
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }

    private byte[] write(int keyLength, int iterations, byte[] salt, byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(keyLength);
        dos.writeShort(0);
        dos.writeInt(iterations);
        dos.writeShort(salt.length);
        dos.write(salt);
        dos.write(data);
        return baos.toByteArray();
    }

    @Override
    public byte[] decode(byte[] toDecode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        try {
            if (salt != null) {
                throw new IllegalArgumentException("Salt is encoded in the data for " + this.getId());
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            ByteArrayInputStream bain = new ByteArrayInputStream(toDecode);
            DataInputStream din = new DataInputStream(bain);
            short keyLength = din.readShort();
            int offset = 6;
            int iterations = din.readShort();
            if (iterations == 0) {
                iterations = din.readInt();
                offset += 4;
            }
            short saltLen = din.readShort();
            salt = new byte[saltLen];
            din.readFully(salt);
            byte[] data = new byte[toDecode.length - offset - saltLen];
            din.readFully(data);
            SecretKey secret = this.getSecretKey(new String(passphrase, charset).toCharArray(), salt, keyLength, iterations);
            byte[] iv = new byte[cipher.getBlockSize()];
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public boolean match(byte[] encodedData, byte[] unencodedData, byte[] passphrase, String charset) {
        try {
            ByteArrayInputStream bain = new ByteArrayInputStream(encodedData);
            DataInputStream din = new DataInputStream(bain);
            short keyLength = din.readShort();
            int iterations = din.readShort();
            int offset = 6;
            if (iterations == 0) {
                iterations = din.readInt();
                offset += 4;
            }
            short saltLen = din.readShort();
            byte[] salt = new byte[saltLen];
            din.readFully(salt);
            byte[] data = new byte[encodedData.length - offset - saltLen];
            din.readFully(data);
            byte[] newEncoded = super.encode(unencodedData, salt, passphrase, charset, keyLength, iterations);
            return Arrays.equals(data, newEncoded);
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

