/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.AbstractEncoder;
import java.io.UnsupportedEncodingException;

public abstract class AbstractUnixSHAEncoder
extends AbstractEncoder {
    private final String saltPrefix;
    private final int size;

    public AbstractUnixSHAEncoder(String id, String saltPrefix, int size) {
        super(id);
        this.saltPrefix = saltPrefix;
        this.size = size;
    }

    @Override
    public boolean match(byte[] encodedData, byte[] unencodedData, byte[] passphrase, String charset) throws EncoderException {
        try {
            if (!this.isOfType(encodedData, charset)) {
                throw new EncoderException("Encoded data is not in Unix SHA crypt format");
            }
            String encoded = new String(encodedData, charset);
            if (encoded.equals("*")) {
                return false;
            }
            if (encoded.startsWith("!")) {
                return false;
            }
            int sl = this.saltPrefix.length();
            int idx = encoded.indexOf(36, sl);
            if (idx == -1) {
                throw new EncoderException("Expected end of salt character $");
            }
            String encsalt = encoded.substring(0, idx);
            String toMatch = this.doCrypt(unencodedData, charset, encsalt);
            return toMatch.equals(encoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    protected abstract String doCrypt(byte[] var1, String var2, String var3) throws UnsupportedEncodingException;

    @Override
    public boolean isOfType(byte[] encodedBytes, String charset) {
        try {
            return new String(encodedBytes, charset).startsWith(this.saltPrefix);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        try {
            if (salt == null) {
                return this.doCrypt(toEncode, charset, null).getBytes(charset);
            }
            String saltString = new String(salt, charset);
            if (saltString.length() < 2) {
                throw new EncoderException("Salt must be at least 2 characters .");
            }
            String crypt = this.doCrypt(toEncode, charset, saltString);
            return crypt.getBytes(charset);
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }
}

