/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.Encoder;
import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.AbstractEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CompoundEncoder
extends AbstractEncoder {
    private List<Encoder> encoders = new ArrayList<Encoder>();

    public CompoundEncoder(String id, Encoder ... encoders) {
        super(id);
        this.encoders.addAll(Arrays.asList(encoders));
    }

    public void addEncoder(Encoder encoder) {
        this.encoders.add(encoder);
    }

    @Override
    public byte[] decode(byte[] toDecode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        ArrayList<Encoder> reverse = new ArrayList<Encoder>(this.encoders);
        Collections.reverse(reverse);
        for (Encoder encoder : reverse) {
            toDecode = encoder.decode(toDecode, null, passphrase, charset);
        }
        return toDecode;
    }

    @Override
    public boolean match(byte[] encodedData, byte[] unencodedData, byte[] passphrase, String charset) {
        for (int i = this.encoders.size() - 1; i >= 0; --i) {
            Encoder enc = this.encoders.get(i);
            if (i == 0) {
                return enc.match(encodedData, unencodedData, passphrase, charset);
            }
            encodedData = enc.decode(encodedData, null, passphrase, charset);
        }
        return false;
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        for (Encoder encoder : this.encoders) {
            toEncode = encoder.encode(toEncode, salt, passphrase, charset);
        }
        return toEncode;
    }

    @Override
    public boolean isOfType(byte[] encodedBytes, String charset) {
        for (Encoder encoder : this.encoders) {
            if (encoder.isOfType(encodedBytes, charset)) continue;
            return false;
        }
        return true;
    }
}

