/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.EncoderManager;
import com.identity4j.util.crypt.impl.AES192Encoder;
import com.identity4j.util.crypt.impl.AES256Encoder;
import com.identity4j.util.crypt.impl.AESEncoder;
import com.identity4j.util.crypt.impl.Base64AES192Encoder;
import com.identity4j.util.crypt.impl.Base64AES256Encoder;
import com.identity4j.util.crypt.impl.Base64AESEncoder;
import com.identity4j.util.crypt.impl.Base64Encoder;
import com.identity4j.util.crypt.impl.Base64FIPSEncoder;
import com.identity4j.util.crypt.impl.Base64NSSEncoder;
import com.identity4j.util.crypt.impl.Base64PBEWithMD5AndDESEncoder;
import com.identity4j.util.crypt.impl.Drupal7Encoder;
import com.identity4j.util.crypt.impl.MD5Base64Encoder;
import com.identity4j.util.crypt.impl.MD5Encoder;
import com.identity4j.util.crypt.impl.MD5StringEncoder;
import com.identity4j.util.crypt.impl.PBEWithMD5AndDESEncoder;
import com.identity4j.util.crypt.impl.PlainEncoder;
import com.identity4j.util.crypt.impl.RawAESEncoder;
import com.identity4j.util.crypt.impl.SHABase64Encoder;
import com.identity4j.util.crypt.impl.SHAEncoder;
import com.identity4j.util.crypt.impl.SHAStringEncoder;
import com.identity4j.util.crypt.impl.UnicodeEncoder;
import com.identity4j.util.crypt.impl.UnixBlowfishEncoder;
import com.identity4j.util.crypt.impl.UnixDESEncoder;
import com.identity4j.util.crypt.impl.UnixMD5Encoder;
import com.identity4j.util.crypt.impl.UnixSHA256Encoder;
import com.identity4j.util.crypt.impl.UnixSHA512Encoder;
import com.identity4j.util.crypt.nss.DefaultNssTokenDatabase;
import com.identity4j.util.crypt.nss.FIPSEncoder;
import com.identity4j.util.crypt.nss.NSSEncoder;
import com.identity4j.util.crypt.nss.NssTokenDatabase;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultEncoderManager
extends EncoderManager {
    static Log log = LogFactory.getLog(DefaultEncoderManager.class);
    private static final EncoderManager INSTANCE = new DefaultEncoderManager();

    private DefaultEncoderManager() {
        try {
            this.addEncoder(new PlainEncoder());
            this.addEncoder(new Base64Encoder());
            this.addEncoder(new UnicodeEncoder());
            this.addEncoder(new MD5Encoder());
            this.addEncoder(new SHAEncoder());
            this.addEncoder(new MD5Base64Encoder());
            this.addEncoder(new SHABase64Encoder());
            this.addEncoder(new MD5StringEncoder());
            this.addEncoder(new SHAStringEncoder());
            this.addEncoder(new RawAESEncoder());
            this.addEncoder(new AESEncoder());
            this.addEncoder(new AES192Encoder());
            this.addEncoder(new AES256Encoder());
            this.addEncoder(new Base64AESEncoder());
            this.addEncoder(new Base64AES192Encoder());
            this.addEncoder(new Base64AES256Encoder());
            this.addEncoder(new PBEWithMD5AndDESEncoder());
            this.addEncoder(new Base64PBEWithMD5AndDESEncoder());
            this.addEncoder(new Drupal7Encoder());
            this.addEncoder(new UnixBlowfishEncoder());
            this.addEncoder(new UnixDESEncoder());
            this.addEncoder(new UnixMD5Encoder());
            this.addEncoder(new UnixSHA256Encoder());
            this.addEncoder(new UnixSHA512Encoder());
            try {
                NssTokenDatabase ntdp = DefaultNssTokenDatabase.getInstance();
                this.addEncoder(new NSSEncoder(ntdp));
                this.addEncoder(new Base64NSSEncoder(ntdp));
                this.addEncoder(new FIPSEncoder(ntdp));
                this.addEncoder(new Base64FIPSEncoder(ntdp));
            }
            catch (IOException e) {
                log.info((Object)"Failed to initialize Nss. No NSS encoders registered.", (Throwable)e);
            }
            catch (Throwable e) {
                log.warn((Object)"Failed to initialize FIPS encoder.", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static EncoderManager getInstance() {
        return INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        DefaultNssTokenDatabase toks = new DefaultNssTokenDatabase();
        toks.start();
    }
}

