/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.AbstractPHPHashEncoder;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class Drupal7Encoder
extends AbstractPHPHashEncoder {
    public static final int DRUPAL_MIN_HASH_COUNT = 7;
    public static final int DRUPAL_HASH_COUNT = 15;
    public static final int DRUPAL_MAX_HASH_COUNT = 30;
    public static final int DRUPAL_HASH_LENGTH = 55;
    public static final String ID = "drupal7";

    public Drupal7Encoder() {
        super(ID);
    }

    @Override
    public boolean isOfType(byte[] encodedBytes, String charset) {
        try {
            return new String(encodedBytes, charset).startsWith("$S$");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    @Override
    public boolean match(byte[] encodedData, byte[] unencodedData, byte[] passphrase, String charset) {
        try {
            String encoded = new String(encodedData, charset);
            String encsalt = encoded.substring(0, 12);
            return Arrays.equals(this.encode(unencodedData, encsalt.getBytes(charset), passphrase, charset), encodedData);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        try {
            return this.passwordCrypt("sha512", toEncode, salt == null ? this.generateSalt(15, charset) : salt, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    private byte[] passwordCrypt(String algo, byte[] passphrase, byte[] salt, String charset) throws UnsupportedEncodingException {
        if (passphrase.length > 512) {
            throw new IllegalArgumentException("Password too long");
        }
        String setting = new String(salt, charset);
        if ((setting = setting.substring(0, 12)).charAt(0) != '$' || setting.charAt(2) != '$') {
            throw new IllegalArgumentException("Invalid salt.");
        }
        int countLog2 = this.passwordGetCountLog2(setting);
        if (countLog2 < 7 || countLog2 > 30) {
            throw new IllegalArgumentException("Invalid count.");
        }
        String hashsalt = setting.substring(4, 12);
        int count = 1 << countLog2;
        String pw = new String(passphrase, charset);
        byte[] hash = this.hash(algo, (hashsalt + pw).getBytes(charset), true, charset);
        do {
            byte[] newhash = new byte[hash.length + passphrase.length];
            System.arraycopy(hash, 0, newhash, 0, hash.length);
            System.arraycopy(passphrase, 0, newhash, hash.length, passphrase.length);
            hash = this.hash(algo, newhash, true, charset);
        } while (--count > 0);
        int len = hash.length;
        String output = setting + this.passwordBase64Encode(hash, len);
        int expected = 12 + (int)Math.ceil(8.0f * (float)len / 6.0f);
        if (output.length() == expected) {
            return (expected > 55 ? output.substring(0, 55) : output).getBytes(charset);
        }
        throw new IllegalArgumentException("Could not encode.");
    }

    private int passwordGetCountLog2(String setting) {
        return this.passwordItoa64().indexOf(setting.charAt(3));
    }

    private byte[] generateSalt(int count, String charset) {
        String output = "$S$";
        count = this.enforceLog2Boundaries(count);
        output = output + this.passwordItoa64().charAt(count);
        output = output + this.passwordBase64Encode(this.randomBytes(6), 6);
        try {
            return output.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String passwordBase64Encode(byte[] input, int count) {
        String output = "";
        int i = 0;
        while (i < count) {
            int val = input[i++] & 0xFF;
            output = output + this.passwordItoa64().charAt(val & 0x3F);
            if (i < count) {
                val |= (input[i] & 0xFF) << 8;
            }
            output = output + this.passwordItoa64().charAt(val >>> 6 & 0x3F);
            if (i++ >= count) break;
            if (i < count) {
                val |= (input[i] & 0xFF) << 16;
            }
            output = output + this.passwordItoa64().charAt(val >>> 12 & 0x3F);
            if (i++ >= count) break;
            output = output + this.passwordItoa64().charAt(val >>> 18 & 0x3F);
        }
        return output;
    }

    private int enforceLog2Boundaries(int count) {
        return Math.max(Math.min(count, 30), 7);
    }

    private String passwordItoa64() {
        return "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    }
}

