/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.Encoder;
import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.Base64Encoder;
import com.identity4j.util.crypt.impl.CompoundEncoder;
import com.identity4j.util.crypt.impl.MessageDigestEncoder;
import java.io.UnsupportedEncodingException;

public class MessageDigestStringEncoder
extends CompoundEncoder {
    private String hashAlgorithm;

    public MessageDigestStringEncoder(String id, String encryptionEncoderId, String hashAlgorithm) {
        super(id, new Encoder[0]);
        this.addEncoder(new MessageDigestEncoder(encryptionEncoderId, hashAlgorithm));
        this.addEncoder(new Base64Encoder());
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        try {
            return ("{" + this.hashAlgorithm + "}" + new String(super.encode(toEncode, salt, passphrase, charset), charset)).getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public boolean match(byte[] encodedData, byte[] unencodedData, byte[] passphrase, String charset) {
        try {
            int idx;
            String hashAlgo;
            String hashstr = new String(encodedData, charset);
            if (hashstr.startsWith("{") && (hashAlgo = hashstr.substring(1, idx = hashstr.indexOf("}"))).equals(this.hashAlgorithm)) {
                hashstr = hashstr.substring(idx + 1);
                return super.match(hashstr.getBytes(charset), unencodedData, passphrase, charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
        return false;
    }

    @Override
    public boolean isOfType(byte[] encodedBytes, String charset) {
        try {
            return new String(encodedBytes, charset).startsWith("{" + this.hashAlgorithm + "}");
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }
}

