/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.AbstractEncoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class RawAESEncoder
extends AbstractEncoder {
    private static final int DEFAULT_KEY_LENGTH = 128;
    private static final int DEFAULT_ITERATIONS = 1024;
    public static final String ID = "aes";
    protected int keyLength;

    public RawAESEncoder() {
        this(ID);
    }

    public RawAESEncoder(String id) {
        this(id, 128);
    }

    public RawAESEncoder(int keyLength) {
        this(ID, 256);
    }

    public RawAESEncoder(String id, int keyLength) {
        super(id);
        this.keyLength = keyLength;
    }

    protected SecretKey getSecretKey(char[] password, byte[] salt, int keyLength, int iterations) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLength);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        return secret;
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        return this.encode(toEncode, salt, passphrase, charset, this.keyLength, 1024);
    }

    protected byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset, int keyLength, int iterations) throws EncoderException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            if (salt == null) {
                throw new IllegalArgumentException("Salt is required for " + this.getId());
            }
            salt = this.checkSaltLength(salt, cipher);
            SecretKey secret = this.getSecretKey(new String(passphrase, charset).toCharArray(), salt, keyLength, iterations);
            byte[] iv = new byte[cipher.getBlockSize()];
            cipher.init(1, (Key)secret, new IvParameterSpec(iv));
            byte[] ciphertext = cipher.doFinal(toEncode);
            return ciphertext;
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }

    protected byte[] checkSaltLength(byte[] salt, Cipher cipher) {
        if (salt.length == 0) {
            salt = new byte[cipher.getBlockSize()];
        }
        return salt;
    }

    @Override
    public byte[] decode(byte[] toDecode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        try {
            if (salt == null) {
                throw new IllegalArgumentException("Salt is required for " + this.getId());
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            salt = this.checkSaltLength(salt, cipher);
            SecretKey secret = this.getSecretKey(new String(passphrase, charset).toCharArray(), salt, this.keyLength, 1024);
            byte[] iv = new byte[cipher.getBlockSize()];
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return cipher.doFinal(toDecode);
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }
}

